﻿using DemoTool.Tool;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Drawing;
using System.IO;
using System.IO.Ports;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using Timer = System.Windows.Forms.Timer;

namespace DemoTool
{
    public partial class Form1 : Form
    {
        //变色按钮列表
        List<Button> buttonList = new List<Button>();
        VizCommand sendCommend = new VizCommand();//Viz命令
        List<string> IPlist = new List<string>();  //创建Viz Ip列表
        string TxtPath = "";

        string AllMiao;
        LogMsg LogMsg = new LogMsg();
        public Form1()
        {
            InitializeComponent();
        }

        #region Viz连接操作

        /// <summary>
        /// /设置点击的按钮为绿色
        /// </summary>
        void SetGreen(Button button)
        {
            if (buttonList.Contains(button))
            {
                for (int i = 0; i < buttonList.Count; i++)
                {
                    buttonList[i].BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(0)))), ((int)(((byte)(128)))), ((int)(((byte)(0)))));
                }
                button.BackColor = Color.Red;
            }
            else
            {
                buttonList.Add(button);
                for (int i = 0; i < buttonList.Count; i++)
                {
                    buttonList[i].BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(0)))), ((int)(((byte)(128)))), ((int)(((byte)(0)))));
                }
                button.BackColor = Color.Red;
            }
        }
        private void connectViz_btn_Click(object sender, EventArgs e)
        {
            SetGreen(this.connectViz_btn);
            Task task = Task.Run(() =>
            {
                ConnectVizFunc();
            });
        }

        private void ConnectVizFunc()
        {
            if (IPlist.Count != 0)
            {
                sendCommend.ConnectViz(IPlist);
                //遍历ip列表
                for (int i = 0; i < IPlist.Count; i++)
                {
                    if (sendCommend.IsConnectVizList[i] == true)
                    {
                        if (i == 0)
                        {
                            IPViz_lab1.ForeColor = Color.Lime;
                            Resultlabel6.Invoke(new Action(() =>
                            {
                                Resultlabel6.Text = "IP1-Viz引擎连接成功！";
                            }));
                            Resultlabel6.ForeColor = Color.Lime;
                            //ReturnDebug.DebugMessage("IP地址为：" + IPlist[0] + "连接成功！", DebugMessageType.ok);
                        }
                        else if (i == 1)
                        {
                            IPViz_lab2.ForeColor = Color.Lime;
                            Resultlabel8.Invoke(new Action(() =>
                            {
                                Resultlabel8.Text = "IP2-Viz引擎连接成功！";
                            }));
                            Resultlabel8.ForeColor = Color.Lime;
                            //ReturnDebug.DebugMessage("IP地址为：" + IPlist[1] + "连接成功！", DebugMessageType.ok);
                        }
                    }
                    else if (sendCommend.IsConnectVizList[i] == false)
                    {
                        if (i == 0)
                        {
                            IPViz_lab1.ForeColor = Color.Red;
                            MessageBox.Show("IP1-有Viz引擎连接失败！");
                            Resultlabel6.Invoke(new Action(() =>
                            {
                                Resultlabel6.Text = "IP1-有Viz引擎连接失败！";
                            }));
                            Resultlabel6.ForeColor = Color.Red;
                            //ReturnDebug.DebugMessage("IP1-地址为：" + IPlist[0] + "连接失败！", DebugMessageType.err);
                        }
                        else if (i == 1)
                        {
                            IPViz_lab2.ForeColor = Color.Red;
                            Resultlabel8.Invoke(new Action(() =>
                            {
                                Resultlabel8.Text = "IP2-Viz引擎连接失败！";
                            }));
                            Resultlabel8.ForeColor = Color.Red;
                            //ReturnDebug.DebugMessage("IP2-地址为：" + IPlist[1] + "连接失败！", DebugMessageType.err);
                        }
                    }
                }
            }
            else
            {
                //ReturnDebug.DebugMessage("没有可供选择的引擎连接！请添加要连接引擎的IP地址：", DebugMessageType.err);
            }
        }

        private void breakViz_btn_Click(object sender, EventArgs e)
        {
            SetGreen(this.breakViz_btn);
            for (int i = 0; i < sendCommend._poolList.Count; i++)
            {
                sendCommend._poolList[i].Disconnect();
                sendCommend._poolList[i].Dispose();
                IPViz_lab1.ForeColor = Color.White;
                IPViz_lab2.ForeColor = Color.White;
                Resultlabel6.ForeColor = Color.Red;
                Resultlabel6.Text = "引擎已断开，请连接Viz...";
                Resultlabel8.ForeColor = Color.Red;
                Resultlabel8.Text = "引擎已断开，请连接Viz...";
            }
        }

        private void reStart_btn_Click(object sender, EventArgs e)
        {
            SetGreen(this.reStart_btn);
            DialogResult dr = MessageBox.Show("是否重启?", "提示:", MessageBoxButtons.OKCancel, MessageBoxIcon.Information);

            if (dr == DialogResult.OK)   //如果单击“是”按钮
            {
                System.Windows.Forms.Application.Restart();
            }
            else if (dr == DialogResult.Cancel)
            {
            }
        }
        //string[] COM_Name = new string[] { "COM1", "COM2", "COM3", "COM4","COM5","COM6","COM7" };
        List<string> Com_Name = new List<string>() { "COM1", "COM2", "COM3", "COM4" };

        public void LoadSum()
        {
            try
            {
                AllMiao = Delay_Jia.Text;
                IPViz_lab1.Text = ConfigurationManager.AppSettings["HomeIP"].ToString();
                IPViz_lab2.Text = ConfigurationManager.AppSettings["PrepareIP"].ToString();
                TxtPath = ConfigurationManager.AppSettings["LogPath"].ToString();
                //imageLocation = ConfigurationManager.AppSettings["ImageLocation"].ToString();
                //teamImageLocation = ConfigurationManager.AppSettings["TeamImageLocation"].ToString();
                //imageDefaultLocation = ConfigurationManager.AppSettings["ImageDefaultLocation"].ToString();
                IPlist.Clear();
                IPlist.Add(IPViz_lab1.Text.Trim());
                IPlist.Add(IPViz_lab2.Text.Trim());
                foreach (var item in Com_Name)
                {
                    com_ComName.Items.Add(item);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }


        }
        #endregion


        //当前应用程序集的执行目录
        string dir = AppDomain.CurrentDomain.BaseDirectory;
        //当前应用程序集的执行的上级目录
        //dir = Path.GetFullPath("..");

        private void Form1_Load(object sender, EventArgs e)
        {
            LoadSum();
            //button1.Enabled = false;
            //button2.Enabled = false;
            //button3.Enabled = false;
        }

        //string转换int帮助函数
        public int ConvertInt32(string name)
        {
            if (name != "" && name != null)
            {
                return Convert.ToInt32(name);
            }
            else
            {
                return 0;
            }
        }
        int Hose, Minut, Second, MS = 0;
        bool IsSecond = true;
        bool IsMS;

        /// <summary>
        /// 停止
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button2_Click(object sender, EventArgs e)
        {
            this.timer1.Stop();
            this.timer1.Enabled = false;
        }
        /// <summary>
        /// 继续
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button3_Click(object sender, EventArgs e)
        {
            this.timer1.Start();
            this.timer1.Enabled = true;
        }
        /// <summary>
        /// 24秒测试开始
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click_1(object sender, EventArgs e)
        {
            try
            {
                Hose = ConvertInt32(textBox1.Text.Trim());
                if (ConvertInt32(textBox2.Text.Trim()) > 60)
                {
                    MessageBox.Show("不能大于60分钟");
                    return;
                }
                else
                {
                    Minut = ConvertInt32(textBox2.Text.Trim());
                }
                if (ConvertInt32(textBox3.Text.Trim()) >= 60)
                {
                    MessageBox.Show("不能大于60秒");
                    return;
                }
                else
                {
                    Second = ConvertInt32(textBox3.Text.Trim());
                }
                this.timer1.Start();
                this.timer1.Enabled = true;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }


        }



        private void timer1_Tick(object sender, EventArgs e)
        {

            if (Second != 0 && Second >= 11)
            {
                timer1.Interval = 1000;
                Second--;
                //给Viz发东西
                //try
                //{
                //    sendCommend.SendViz24(Second.ToString());
                //}
                //catch (Exception ex)
                //{
                //    Console.WriteLine(ex.Message);
                //}
            }
            // 处理毫秒
            else if (Second != 0 && Second <= 10)
            {
                timer1.Interval = 110;
                if (MS == 0 && Second != 0)
                {
                    if (Second != 0)
                    {
                        Second--;
                        MS = 9;
                    }
                    if (Second == 0)
                    {
                        MS = 0;
                    }
                }
                else
                {
                    MS--;
                    //sendCommend.SendViz24(Second.ToString() + "." + MS.ToString());
                }
            }
            if (Second == 0)
            {
                if (Minut != 0)
                {
                    Second += 60;
                    Minut--;
                }
            }
            if (Minut == 0)
            {
                if (Hose != 0)
                {
                    Minut += 60;
                    Hose--;
                }
            }

            label3.Text = Hose.ToString();
            label2.Text = Minut.ToString();
            label1.Text = Second.ToString();
            label18.Text = MS.ToString();
            if (Second != 0 && Second > 10)
            {
                if (sendCommend != null)
                {
                    sendCommend.SendViz24(TimeDataSend(Second.ToString()));
                }
            }
            else
            {
                if (sendCommend != null)
                {
                    sendCommend.SendViz24(TimeDataSend(Second.ToString() + "." + MS.ToString()));
                }
            }
        }

        string data;
        public string TimeDataSend(string str)
        {
            data = "";
            data += str.Replace(" ", "") + "*";
            if (num_Delay_Jia.Text == "0.0")
            {
                data += "0".Replace(" ", "") + "*";
            }
            else
            {
                data += num_Delay_Jia.Text.Replace(" ", "") + "*";
            }
            if (num_Delay_Jian.Text == "0.0")
            {
                data += "0".Replace(" ", "");
            }
            else
            {
                data += num_Delay_Jian.Text.Replace(" ", "");
            }

            //data += num_Delay_Jian.Text.Replace(" ", "") ;
            Console.WriteLine("当前秒钟数据====>" + data);
            return data;
        }

        public void OpenSbar()
        {
            if (serialPort1.IsOpen == false)
            {
                serialPort1.Open();
            }
            serialPort1.DataReceived += new SerialDataReceivedEventHandler(SBar_DataReceived);
        }


        private void SBar_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            //this.labelCode.Text = "等待中...";
            Thread.Sleep(100);
            string str_Buff = serialPort1.ReadExisting();
            str_Buff = System.Text.RegularExpressions.Regex.Replace(str_Buff, @"[^0-9a-zA-Z]+", "");
            //获取到的数据
            string Code = str_Buff.Trim();
        }

        private void but_Connect_Click(object sender, EventArgs e)
        {
            if (txt_Tcp_IP.Text.Trim() != "" && txt_Tcp_IP.Text.Trim() != null && txt_Tcp_Com.Text.Trim() != "" && txt_Tcp_Com.Text.Trim() != null)
            {
                SetGreen(this.but_Connect);
                txt_ALL_Data.AppendText("IP形式连接\r\n");
                Client();
            }
            //串口暂时未能使用
            else if (com_ComName.Text != null && com_ComName.Text != "" && txt_BaudRate.Text != "" && txt_BaudRate.Text != null)
            {
                txt_ALL_Data.AppendText("COM口形式连接\r\n");
                setPort();
            }

        }
        /// <summary>
        /// 断开所有通信的连接
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void but_Close_Click(object sender, EventArgs e)
        {
            //关闭Socket
            CloseSocket();
            //关闭串口
            ClosePort();

        }

        //public void send_data(SerialPort st, string send_txt, out string msg)
        //{
        //    if (com_sta == "关闭")
        //    {
        //        byte[] send = new byte[] { 00, 00, 00, 00, 00, 00, 00, 00 };
        //        string[] gam = send_txt.Trim().Split(' ');
        //        for (int i = 0; i < gam.Length; i++)
        //        {
        //            send[i] = Convert.ToByte(gam[i], 16);
        //        }
        //        string yh = modbus.ToModbusCRC16(send_txt, true);
        //        send[gam.Length] = Convert.ToByte(yh.Substring(0, 2), 16);
        //        send[gam.Length + 1] = Convert.ToByte(yh.Substring(2, 2), 16);
        //        string str = "";
        //        foreach (var xs in send)
        //        {
        //            str += Convert.ToString(xs, 16).ToUpper().Length == 1 ? "0" + Convert.ToString(xs, 16).ToUpper() + " " : Convert.ToString(xs, 16).ToUpper() + " ";
        //        }
        //        //发送
        //        try
        //        {
        //            Thread.Sleep(5);
        //            st.Write(send, 0, send.Length);
        //            msg = "准备就绪";
        //        }
        //        catch { msg = "erro"; }
        //    }
        //    else
        //    {
        //        msg = "端口没打开！";
        //    }
        //}

        #region Socket链接方式
        Socket socket;
        Thread threadSocket;
        bool IsReceive = true;
        public void Client()
        {
            try
            {
                socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
                socket.Connect(IPAddress.Parse(txt_Tcp_IP.Text), int.Parse(txt_Tcp_Com.Text));
                label10.Text = "IP形式连接成功";
                txt_ALL_Data.AppendText("IP形式连接成功\r\n");
                threadSocket = new Thread(OnSendOrReceive);
                threadSocket.IsBackground = true;
                threadSocket.Start(socket);
                threadSocket = new Thread(SokcetDempo);
                threadSocket.IsBackground = true;
                threadSocket.Start();

                //ThreadPool.QueueUserWorkItem(OnSendOrReceive, socket);
                //this.but_Connect.Enabled = false;
                //but_Close.Enabled = true;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                label10.Text = "IP形式连接失败";
                txt_ALL_Data.AppendText("IP形式连接失败\r\n");
                MessageBox.Show("IP形式连接失败");
            }
        }
        bool isOk;
        string isSum = "0";
        Queue<byte[]> HoseQueue = new Queue<byte[]>();
        //Thread txtRead= new Thread()
        Log log = new Log();
        private void OnSendOrReceive(object sk)
        {
            var socket = sk as Socket;
            int r = 0;
            bool temp = false;
            int tempCt = 0;
            string text = "";
            string strText = "";

            while (true)
            {
                try
                {
                    //客户端连接成功后，服务器应该接受客户端发来的消息
                    byte[] buffer2 = new byte[20];
                    //实际接收到的字节数组
                    r = socket.Receive(buffer2);
                    byte[] buffer = new byte[20];
                    for (int i = 0; i < buffer2.Length; i++)
                    {
                        try
                        {
                            if (buffer2[i].ToString("X8").Replace("0", "") == "CD")
                            {
                                if (i == 8)
                                {
                                    buffer = buffer2;
                                    for (int k = 0; k <= 8; k++)
                                    {
                                        try
                                        {
                                            text += buffer[k].ToString("X2") + " ";
                                            strText += buffer[k].ToString() + " ";
                                        }
                                        catch
                                        {
                                        }
                                    }
                                    break;
                                }
                                else
                                {
                                    if (!temp)
                                    {
                                        temp = true;
                                    }
                                    else
                                    {
                                        temp = false;
                                        tempCt = 0;
                                        break;
                                    }
                                }
                            }
                            if (temp)
                            {
                                buffer[tempCt] = buffer2[i + 1];
                                tempCt++;
                                text += buffer2[i + 1].ToString("X2") + " ";
                                strText += buffer2[i + 1].ToString() + " ";
                            }
                        }
                        catch (Exception ex)
                        {
                            LogMsg.WriteErrLogMsg("重置接受到的字节出错：" + ex.Message);
                        }
                    }

                    HoseQueue.Enqueue(buffer);
                    this.BeginInvoke(new EventHandler(delegate
                    {
                        try
                        {
                            //string TxtPath = @"D:\txt\txt123\";
                            string postPath = TxtPath + DateTime.Now.ToString("yyyy-MM-dd hh-mm") + ".log";
                            if (Directory.Exists(TxtPath) == false)
                            {
                                Directory.CreateDirectory(postPath);
                            }
                            else
                            {
                                //log.deleteLog(@"D:\txt");
                                using (System.IO.StreamWriter file = new System.IO.StreamWriter(postPath, true))
                                {
                                    //string swTxt = BitConverter.ToString(buffer).Replace(" - ", "");
                                    file.WriteLine(DateTime.Now.ToString("HH-mm-ss-fff") + ":   " + text + "         " + strText);
                                    text = "";
                                    strText = "";
                                }
                            }
                            if (txt_ALL_Data.TextLength > 20 * 10000)
                            {
                                txt_ALL_Data.Text = "";
                            }
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine(ex.Message);
                        }
                    }));

                    #region  未加队列之前处理
                    //if (IsReceive)
                    //{
                    //    //24秒
                    //    sumTwo = buffer[5].ToString();
                    //    //24秒之后的毫秒
                    //    Hmiao = buffer[4].ToString();
                    //    #region 接受16进制的状态码
                    //    //正常跑动
                    //    if ((buffer[0].ToString("X2") == "21" && buffer[1].ToString("X2") == "00") || (buffer[0].ToString("X2") == "60" && buffer[1].ToString("X2") == "00") || (buffer[0].ToString("X2") == "20" && buffer[1].ToString("X2") == "00"))
                    //    {
                    //        Hmiao = Hmiao.Substring(0, 1);
                    //        if (int.Parse(sumTwo) >= 5)
                    //        {
                    //            //24
                    //            if (isSum!=sumTwo && int.Parse(sumTwo)<24)
                    //            {

                    //                if (int.Parse(sumTwo) == 5 && int.Parse(Hmiao) <= 1)
                    //                {

                    //                    this.BeginInvoke(new EventHandler(delegate
                    //                    {
                    //                        txt_One_Data.Text = sumTwo;

                    //                        txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----五秒----" + Hmiao + "\r\n");
                    //                    }));
                    //                    //给Viz发送数据
                    //                    if (sendCommend != null)
                    //                    {
                    //                        sendCommend.SendViz24(TimeDataSend(sumTwo));
                    //                    }
                    //                    WuMiao = true;

                    //                }
                    //                else
                    //                {
                    //                    if(WuMiao == true)
                    //                    {
                    //                        //什么都不干
                    //                    }
                    //                    else
                    //                    {
                    //                        //这里再加1发
                    //                        string txtSum = (int.Parse(sumTwo) + 1).ToString();
                    //                        this.BeginInvoke(new EventHandler(delegate
                    //                        {
                    //                            txt_One_Data.Text = sumTwo;
                    //                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + txtSum + "----大于五秒+1----" + Hmiao + "\r\n");
                    //                            isOk = false;
                    //                            isSum = "0";
                    //                        }));
                    //                        //给Viz发送数据
                    //                        if (sendCommend != null)
                    //                        {
                    //                            sendCommend.SendViz24(TimeDataSend(txtSum));
                    //                        }
                    //                    }

                    //                }

                    //            }
                    //        }
                    //        else
                    //        {
                    //            WuMiao = false;
                    //            this.BeginInvoke(new EventHandler(delegate
                    //            {
                    //                txt_One_Data.Text = sumTwo;

                    //                txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----小于五秒----" + Hmiao + "\r\n");
                    //            }));
                    //            //给Viz发送数据
                    //            if (sendCommend != null)
                    //            {
                    //                sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                    //            }
                    //        }

                    //    }

                    //    //14秒和24秒复位   
                    //    if (buffer[0].ToString("X2") == "00" && buffer[1].ToString("X2") == "00" &&(buffer[5].ToString("X2") == "0E"|| buffer[5].ToString("X2") == "18"))
                    //    {
                    //        WuMiao = false;
                    //        if (int.Parse(sumTwo) >= 5)
                    //        {
                    //            Hmiao = Hmiao.Substring(0, 1);

                    //            this.BeginInvoke(new EventHandler(delegate
                    //            {
                    //                txt_One_Data.Text = sumTwo + "." + Hmiao;
                    //                txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "-.-.-.-.-.-.-.-.-" + Hmiao + "\r\n");

                    //            }));
                    //            //给Viz发送数据
                    //            if (sendCommend != null)
                    //            {
                    //                sendCommend.SendViz24(TimeDataSend(sumTwo));
                    //            }
                    //            isOk = true;
                    //            isSum = sumTwo;
                    //        }
                    //        else
                    //        {
                    //            this.BeginInvoke(new EventHandler(delegate
                    //            {
                    //                txt_One_Data.Text = sumTwo;

                    //                txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----小于五秒----" + Hmiao + "\r\n");
                    //            }));
                    //            //给Viz发送数据
                    //            if (sendCommend != null)
                    //            {
                    //                sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                    //            }
                    //        }
                    //    }

                    //    //清屏  
                    //    if ((buffer[0].ToString("X2") == "10" && buffer[1].ToString("X2") == "00")||((buffer[0].ToString("X2") == "11" && buffer[1].ToString("X2") == "00") || ((buffer[0].ToString("X2") == "00" && buffer[1].ToString("X2") == "01"))))
                    //    {
                    //        this.BeginInvoke(new EventHandler(delegate
                    //        {
                    //            WuMiao = false;
                    //            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + ":清屏\r\n");
                    //        }));
                    //        if (sendCommend != null)
                    //        {
                    //            sendCommend.SendViz24(TimeDataSend(" "));
                    //        }
                    //    }
                    //    //03 00 24秒到0时   01 00 只走时间 24秒为0时  
                    //    if ((buffer[0].ToString("X2") == "03" && buffer[1].ToString("X2") == "00" && buffer[5].ToString("X2") == "00") || ((buffer[0].ToString("X2") == "01" && buffer[1].ToString("X2") == "00" && buffer[5].ToString("X2") == "00")) || ((buffer[0].ToString("X2") == "02" && buffer[1].ToString("X2") == "00")))
                    //    {
                    //        //给Viz发送数据
                    //        if (sendCommend != null)
                    //        {
                    //            WuMiao = false;
                    //            sendCommend.SendViz24(TimeDataSend("0.0"));
                    //        }
                    //    }

                    //    #region 同时停止

                    //    //if (buffer[0].ToString("X2") == "00" && buffer[1].ToString("X2") == "00")
                    //    //{
                    //    //    Hmiao = Hmiao.Substring(0, 1);
                    //    //    if(int.Parse(sumTwo) >= 5)
                    //    //    {
                    //    //        this.BeginInvoke(new EventHandler(delegate
                    //    //        {
                    //    //            txt_One_Data.Text = sumTwo + "." + Hmiao;
                    //    //            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "-.-.-.-.-.-.-.-.-" + Hmiao + "\r\n");
                    //    //            isOk = true;
                    //    //            isSum = sumTwo;
                    //    //        }));
                    //    //        //给Viz发送数据
                    //    //        if (sendCommend != null)
                    //    //        {
                    //    //            sendCommend.SendViz24(TimeDataSend(sumTwo));
                    //    //        }
                    //    //    }
                    //    //    else
                    //    //    {
                    //    //        this.BeginInvoke(new EventHandler(delegate
                    //    //        {
                    //    //            txt_One_Data.Text = sumTwo;

                    //    //            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----小于五秒----" + Hmiao + "\r\n");
                    //    //        }));
                    //    //        //给Viz发送数据
                    //    //        if (sendCommend != null)
                    //    //        {
                    //    //            sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                    //    //        }
                    //    //    }

                    //    //}
                    //    #endregion

                    //    //只走时间 24秒不走
                    //    #region MyRegion
                    //    if ((buffer[0].ToString("X2") == "01" && buffer[1].ToString("X2") == "00") )
                    //    {
                    //        isOk = true;
                    //        isSum = sumTwo;
                    //        WuMiao = false;
                    //        Hmiao = Hmiao.Substring(0, 1);
                    //        if (int.Parse(sumTwo) >= 5)
                    //        {
                    //            if (int.Parse(Hmiao) != 0&&(!(buffer[5].ToString("X2") == "0E" || buffer[5].ToString("X2") == "18")))
                    //            {
                    //                sumTwo = (int.Parse(sumTwo) + 1).ToString();
                    //            }
                    //            this.BeginInvoke(new EventHandler(delegate
                    //            {
                    //                txt_One_Data.Text = sumTwo;

                    //                txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----大于五秒----" + Hmiao + "\r\n");
                    //            }));
                    //            //给Viz发送数据
                    //            if (sendCommend != null)
                    //            {
                    //                sendCommend.SendViz24(TimeDataSend(sumTwo));
                    //            }
                    //        }
                    //        else
                    //        {
                    //            this.BeginInvoke(new EventHandler(delegate
                    //            {
                    //                txt_One_Data.Text = sumTwo;

                    //                txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----小于五秒----" + Hmiao + "\r\n");
                    //            }));
                    //            //给Viz发送数据
                    //            if (sendCommend != null)
                    //            {
                    //                sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                    //            }
                    //        }

                    //        //给Viz发送数据
                    //        //if (sendCommend != null)
                    //        //{
                    //        //    sendCommend.SendViz24(TimeDataSend(sumTwo));
                    //        //}
                    //    }
                    //    #endregion
                    //    #endregion





                    //    #region 状态码未改
                    //    //if (int.Parse(sumTwo) <= 24)
                    //    //{
                    //    //    if ((buffer[1] == 0 || buffer[1] == 21 || buffer[1] == 08) && buffer[0] == 0)
                    //    //    {
                    //    //        if (int.Parse(sumTwo) >= 5)
                    //    //        {
                    //    //            try
                    //    //            {
                    //    //                if (isOk == true && (buffer[5] == 14 || buffer[5] == 24))
                    //    //                {
                    //    //                    Hmiao = Hmiao.Substring(0, 1);
                    //    //                    this.BeginInvoke(new EventHandler(delegate
                    //    //                    {
                    //    //                        txt_One_Data.Text = sumTwo + "." + Hmiao;
                    //    //                        txt_ALL_Data.AppendText(sumTwo + "-.-.-.-.-.-.-.-.-" + Hmiao + "\r\n");
                    //    //                    }));
                    //    //                    //给Viz发送数据
                    //    //                    if (sendCommend != null)
                    //    //                    {
                    //    //                        sendCommend.SendViz24(TimeDataSend(sumTwo));
                    //    //                    }
                    //    //                }
                    //    //                else
                    //    //                {
                    //    //                    if (isSum != int.Parse(sumTwo))
                    //    //                    {
                    //    //                        if (int.Parse(sumTwo) == 5)
                    //    //                        {
                    //    //                            if (int.Parse(Hmiao) != 0 && int.Parse(sumTwo) != 24)
                    //    //                            {
                    //    //                                //这里再加1发
                    //    //                                string txtSum = (int.Parse(sumTwo) + 1).ToString();
                    //    //                                this.BeginInvoke(new EventHandler(delegate
                    //    //                                {
                    //    //                                    txt_One_Data.Text = sumTwo;

                    //    //                                    txt_ALL_Data.AppendText(txtSum + "--------" + Hmiao + "\r\n");
                    //    //                                }));
                    //    //                                //给Viz发送数据
                    //    //                                if (sendCommend != null)
                    //    //                                {
                    //    //                                    sendCommend.SendViz24(TimeDataSend(txtSum));
                    //    //                                }
                    //    //                                isOk = false;
                    //    //                                isSum = 0;
                    //    //                            }
                    //    //                            else
                    //    //                            {
                    //    //                                Hmiao = Hmiao.Substring(0, 1);
                    //    //                                this.BeginInvoke(new EventHandler(delegate
                    //    //                                {
                    //    //                                    txt_One_Data.Text = sumTwo + "." + Hmiao;
                    //    //                                    txt_ALL_Data.AppendText(sumTwo + "+++++++++" + Hmiao + "\r\n");
                    //    //                                }));
                    //    //                                //给Viz发送数据
                    //    //                                if (sendCommend != null)
                    //    //                                {
                    //    //                                    sendCommend.SendViz24(TimeDataSend(sumTwo));
                    //    //                                }
                    //    //                                isOk = false;
                    //    //                                isSum = 0;
                    //    //                            }
                    //    //                        }
                    //    //                        else
                    //    //                        {
                    //    //                            //这里再加1发
                    //    //                            string txtSum = (int.Parse(sumTwo) + 1).ToString();
                    //    //                            this.BeginInvoke(new EventHandler(delegate
                    //    //                            {
                    //    //                                txt_One_Data.Text = sumTwo;

                    //    //                                txt_ALL_Data.AppendText(txtSum + "--------" + Hmiao + "\r\n");
                    //    //                            }));
                    //    //                            //给Viz发送数据
                    //    //                            if (sendCommend != null)
                    //    //                            {
                    //    //                                sendCommend.SendViz24(TimeDataSend(txtSum));
                    //    //                            }
                    //    //                            isOk = false;
                    //    //                            isSum = 0;
                    //    //                        }

                    //    //                    }
                    //    //                    else
                    //    //                    {
                    //    //                        Hmiao = Hmiao.Substring(0, 1);
                    //    //                        this.BeginInvoke(new EventHandler(delegate
                    //    //                        {
                    //    //                            txt_One_Data.Text = sumTwo + "." + Hmiao;
                    //    //                            txt_ALL_Data.AppendText(sumTwo + "." + Hmiao + "\r\n");
                    //    //                        }));
                    //    //                        //给Viz发送数据
                    //    //                        if (sendCommend != null)
                    //    //                        {
                    //    //                            sendCommend.SendViz24(TimeDataSend(sumTwo));
                    //    //                        }
                    //    //                    }
                    //    //                }
                    //    //            }
                    //    //            catch (Exception ex)
                    //    //            {
                    //    //                Console.WriteLine(ex.Message);
                    //    //            }

                    //    //        }
                    //    //        else
                    //    //        {
                    //    //            Hmiao = Hmiao.Substring(0, 1);
                    //    //            this.BeginInvoke(new EventHandler(delegate
                    //    //            {
                    //    //                txt_One_Data.Text = sumTwo + "." + Hmiao;
                    //    //                txt_ALL_Data.AppendText(sumTwo + "+.+.+.+.+.+" + Hmiao + "\r\n");
                    //    //            }));
                    //    //            //给Viz发送数据
                    //    //            if (sendCommend != null)
                    //    //            {
                    //    //                sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                    //    //            }
                    //    //        }
                    //    //    }
                    //    //    else
                    //    //    {
                    //    //        if (buffer[1] == 18 || buffer[1] == 10 || buffer[1] == 11 || buffer[1] == 14 || buffer[1] == 1)
                    //    //        {
                    //    //            if (sendCommend != null)
                    //    //            {
                    //    //                sendCommend.SendViz24(TimeDataSend(" "));
                    //    //            }
                    //    //        }
                    //    //        else
                    //    //        {
                    //    //            //给Viz发送数据
                    //    //            if (sendCommend != null)
                    //    //            {
                    //    //                sendCommend.SendViz24(TimeDataSend(sumTwo));
                    //    //                isOk = true;
                    //    //                isSum = int.Parse(sumTwo);
                    //    //            }
                    //    //        }
                    //    //    }
                    //    //}
                    //    #endregion

                    //}
                    //else
                    //{
                    //    Thread.Sleep(1);
                    //}
                    #endregion

                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                    LogMsg.WriteErrLogMsg("当前Receive接受出错："+ex.Message);
                    this.BeginInvoke(new EventHandler(delegate
                    {
                        //txt_ALL_Data.AppendText("IP形式接受数据失败\r\n");
                    }));
                }
            }
        }
        Timer timerTwo = new Timer();

        public void SokcetDempo()
        {
            string sumTwo = "0";
            string Hmiao = "0";
            bool WuMiao = false;
            string HmiaoTwo = "0";
            string JLText = "";
            bool IsQP = false;
            while (true)
            {
                try
                {
                    #region  加队列之后处理
                    if (HoseQueue.Count>0)
                    {
                        byte[] buffer = new byte[20];
                        buffer=HoseQueue.Dequeue();

                        if (buffer != null)
                        {
                            sumTwo = buffer[5].ToString();
                            //24秒之后的毫秒
                            Hmiao = buffer[4].ToString();
                            HmiaoTwo = Hmiao;
                            Hmiao = Hmiao.Substring(0, 1);
                            JLText = "";
                            #region 接受16进制的状态码
                            //正常跑动
                            if ((buffer[0].ToString("X2") == "21" && buffer[1].ToString("X2") == "00") || (buffer[0].ToString("X2") == "60" && buffer[1].ToString("X2") == "00") || (buffer[0].ToString("X2") == "20" && buffer[1].ToString("X2") == "00"))
                            {
                                if(buffer[2]==0 && buffer[3] <= 24)
                                {
                                    if(IsQP == true)
                                    {
                                        this.BeginInvoke(new EventHandler(delegate
                                        {
                                            WuMiao = false;
                                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + ":大时钟小于24清屏\r\n");
                                        }));
                                        if (sendCommend != null)
                                        {
                                            sendCommend.SendViz24(TimeDataSend(" "));
                                        }
                                    }
                                    else
                                    {
                                        if(buffer[5] == 0)
                                        {
                                            this.BeginInvoke(new EventHandler(delegate
                                            {
                                                WuMiao = false;
                                                txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + ":大时钟小于24清屏\r\n");
                                            }));
                                            if (sendCommend != null)
                                            {
                                                sendCommend.SendViz24(TimeDataSend(" "));
                                            }
                                        }
                                        else
                                        {
                                            if (int.Parse(sumTwo) >= 5)
                                            {
                                                //24
                                                if (isSum != sumTwo && int.Parse(sumTwo) < 24)
                                                {
                                                    if (int.Parse(sumTwo) == 5 && int.Parse(Hmiao) <= 1)
                                                    {

                                                        this.BeginInvoke(new EventHandler(delegate
                                                        {
                                                            txt_One_Data.Text = sumTwo;

                                                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----五秒----" + HmiaoTwo + "\r\n");
                                                        }));
                                                        //给Viz发送数据
                                                        if (sendCommend != null)
                                                        {
                                                            sendCommend.SendViz24(TimeDataSend(sumTwo));
                                                        }
                                                        WuMiao = true;

                                                    }
                                                    else
                                                    {
                                                        if (WuMiao == true)
                                                        {
                                                            //什么都不干
                                                        }
                                                        else
                                                        {
                                                            if (int.Parse(HmiaoTwo) >= 10)
                                                            {
                                                                //这里再加1发
                                                                sumTwo = (int.Parse(sumTwo) + 1).ToString();
                                                                JLText = "+1    ";
                                                            }
                                                            this.BeginInvoke(new EventHandler(delegate
                                                            {
                                                                txt_One_Data.Text = sumTwo;
                                                                txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----大于五秒+1----" + JLText + HmiaoTwo + "\r\n");
                                                                isOk = false;
                                                                isSum = "0";
                                                            }));
                                                            //给Viz发送数据
                                                            if (sendCommend != null)
                                                            {
                                                                sendCommend.SendViz24(TimeDataSend(sumTwo));
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            else
                                            {
                                                if (int.Parse(HmiaoTwo) < 10)
                                                {
                                                    Hmiao = "0";
                                                }
                                                WuMiao = false;
                                                this.BeginInvoke(new EventHandler(delegate
                                                {
                                                    txt_One_Data.Text = sumTwo;
                                                    txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----小于五秒----" + HmiaoTwo + "\r\n");
                                                }));
                                                //给Viz发送数据
                                                if (sendCommend != null)
                                                {
                                                    sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                                                }
                                            }
                                        }
                                    }
                                    
                                }
                                else
                                {
                                    IsQP = false;
                                    if (int.Parse(sumTwo) >= 5)
                                    {
                                        //24
                                        if (isSum != sumTwo && int.Parse(sumTwo) < 24)
                                        {
                                            if (int.Parse(sumTwo) == 5 && int.Parse(Hmiao) <= 1)
                                            {

                                                this.BeginInvoke(new EventHandler(delegate
                                                {
                                                    txt_One_Data.Text = sumTwo;

                                                    txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----五秒----" + HmiaoTwo + "\r\n");
                                                }));
                                                //给Viz发送数据
                                                if (sendCommend != null)
                                                {
                                                    sendCommend.SendViz24(TimeDataSend(sumTwo));
                                                }
                                                WuMiao = true;

                                            }
                                            else
                                            {
                                                if (WuMiao == true)
                                                {
                                                    //什么都不干
                                                }
                                                else
                                                {
                                                    if (int.Parse(HmiaoTwo) >= 10)
                                                    {
                                                        //这里再加1发
                                                        sumTwo = (int.Parse(sumTwo) + 1).ToString();
                                                        JLText = "+1    ";
                                                    }
                                                    this.BeginInvoke(new EventHandler(delegate
                                                    {
                                                        txt_One_Data.Text = sumTwo;
                                                        txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----大于五秒+1----" + JLText + HmiaoTwo + "\r\n");
                                                        isOk = false;
                                                        isSum = "0";
                                                    }));
                                                    //给Viz发送数据
                                                    if (sendCommend != null)
                                                    {
                                                        sendCommend.SendViz24(TimeDataSend(sumTwo));
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    else
                                    {
                                        if (int.Parse(HmiaoTwo) < 10)
                                        {
                                            Hmiao = "0";
                                        }
                                        WuMiao = false;
                                        this.BeginInvoke(new EventHandler(delegate
                                        {
                                            txt_One_Data.Text = sumTwo;
                                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----小于五秒----" + HmiaoTwo + "\r\n");
                                        }));
                                        //给Viz发送数据
                                        if (sendCommend != null)
                                        {
                                            sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                                        }
                                    }
                                }
                               
                            }

                            //14秒和24秒复位   
                            if (buffer[0].ToString("X2") == "00" && buffer[1].ToString("X2") == "00" && (buffer[5].ToString("X2") == "0E" || buffer[5].ToString("X2") == "18"))
                            {
                                WuMiao = false;
                                if (buffer[2] == 0 && buffer[3] <= 24 )
                                {
                                    IsQP = true;
                                    this.BeginInvoke(new EventHandler(delegate
                                    {
                                        WuMiao = false;
                                        txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + ":大时钟小于24清屏\r\n");
                                    }));
                                    if (sendCommend != null)
                                    {
                                        sendCommend.SendViz24(TimeDataSend(" "));
                                    }
                                }
                                else
                                {
                                    IsQP = false;
                                    if (int.Parse(sumTwo) >= 5)
                                    {
                                        if (int.Parse(HmiaoTwo) >= 10)
                                        {
                                            //这里再加1发
                                            sumTwo = (int.Parse(sumTwo) + 1).ToString();
                                            JLText = "+1    ";
                                        }
                                        this.BeginInvoke(new EventHandler(delegate
                                        {
                                            txt_One_Data.Text = sumTwo + "." + Hmiao;
                                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "       14And24复位" + HmiaoTwo + "\r\n");

                                        }));
                                        //给Viz发送数据
                                        if (sendCommend != null)
                                        {
                                            sendCommend.SendViz24(TimeDataSend(sumTwo));
                                        }
                                        isOk = true;
                                        isSum = sumTwo;
                                    }
                                    else
                                    {
                                        if (int.Parse(HmiaoTwo) < 10)
                                        {
                                            Hmiao = "0";
                                        }
                                        this.BeginInvoke(new EventHandler(delegate
                                        {
                                            txt_One_Data.Text = sumTwo;

                                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----小于五秒24And14----" + HmiaoTwo + "\r\n");
                                        }));
                                        //给Viz发送数据
                                        if (sendCommend != null)
                                        {
                                            sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                                        }
                                    }
                                }
                              
                            }
                            else if (buffer[0].ToString("X2") == "00" && buffer[1].ToString("X2") == "00")
                            {

                                WuMiao = false;
                                if (buffer[2] == 0 && buffer[3] <= 24 && buffer[5] == 0)
                                {
                                    this.BeginInvoke(new EventHandler(delegate
                                    {
                                        WuMiao = false;
                                        txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + ":大时钟小于24清屏\r\n");
                                    }));
                                    if (sendCommend != null)
                                    {
                                        sendCommend.SendViz24(TimeDataSend(" "));
                                    }
                                }
                                else
                                {
                                    if (int.Parse(sumTwo) >= 5)
                                    {
                                        if (int.Parse(HmiaoTwo) >= 10)
                                        {
                                            //这里再加1发
                                            sumTwo = (int.Parse(sumTwo) + 1).ToString();
                                            JLText = "+1    ";
                                        }

                                        this.BeginInvoke(new EventHandler(delegate
                                        {
                                            txt_One_Data.Text = sumTwo + "." + Hmiao;
                                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + JLText + sumTwo + "-.-.-.-.-.-.-.-.-" + HmiaoTwo + "\r\n");

                                        }));
                                        //给Viz发送数据
                                        if (sendCommend != null)
                                        {
                                            sendCommend.SendViz24(TimeDataSend(sumTwo));
                                        }
                                    }
                                    else
                                    {
                                        if (int.Parse(HmiaoTwo) < 10)
                                        {
                                            Hmiao = "0";
                                        }
                                        this.BeginInvoke(new EventHandler(delegate
                                        {
                                            txt_One_Data.Text = sumTwo;

                                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----小于五秒----" + HmiaoTwo + "\r\n");
                                        }));
                                        //给Viz发送数据
                                        if (sendCommend != null)
                                        {
                                            sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                                        }
                                    }
                                }
                               
                            }

                            //清屏  
                            if ((buffer[0].ToString("X2") == "10" && buffer[1].ToString("X2") == "00") || ((buffer[0].ToString("X2") == "11" && buffer[1].ToString("X2") == "00") || ((buffer[0].ToString("X2") == "00" && buffer[1].ToString("X2") == "01"))))
                            {
                                this.BeginInvoke(new EventHandler(delegate
                                {
                                    WuMiao = false;
                                    txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + ":清屏\r\n");
                                }));
                                if (sendCommend != null)
                                {
                                    sendCommend.SendViz24(TimeDataSend(" "));
                                }
                            }
                            //03 00 24秒到0时   01 00 只走时间 24秒为0时  
                            if ((buffer[0].ToString("X2") == "03" && buffer[1].ToString("X2") == "00" && buffer[5].ToString("X2") == "00") || ((buffer[0].ToString("X2") == "01" && buffer[1].ToString("X2") == "00" && buffer[5].ToString("X2") == "00")) || ((buffer[0].ToString("X2") == "02" && buffer[1].ToString("X2") == "00")))
                            {
                                //给Viz发送数据
                                if (sendCommend != null)
                                {
                                    WuMiao = false;
                                    sendCommend.SendViz24(TimeDataSend("0.0"));
                                }
                            }
                            //只走时间 24秒不走
                            if ((buffer[0].ToString("X2") == "01" && buffer[1].ToString("X2") == "00"))
                            {
                                isOk = true;
                                isSum = sumTwo;
                                WuMiao = false;
                                if (buffer[2] == 0 && buffer[3] <= 24 )
                                {
                                    this.BeginInvoke(new EventHandler(delegate
                                    {
                                        WuMiao = false;
                                        txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + ":大时钟小于24清屏\r\n");
                                    }));
                                    if (sendCommend != null)
                                    {
                                        sendCommend.SendViz24(TimeDataSend(" "));
                                    }
                                }
                                else
                                {

                                    if (int.Parse(sumTwo) >= 5)
                                    {
                                        if (int.Parse(HmiaoTwo) >= 10 && !(buffer[5].ToString("X2") == "18"))
                                        {
                                            sumTwo = (int.Parse(sumTwo) + 1).ToString();
                                            JLText = "+1   ";
                                        }
                                        this.BeginInvoke(new EventHandler(delegate
                                        {
                                            txt_One_Data.Text = sumTwo;
                                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + JLText + sumTwo + "----大于五秒只走时间 24秒不走----" + HmiaoTwo + "\r\n");
                                        }));
                                        //给Viz发送数据
                                        if (sendCommend != null)
                                        {
                                            sendCommend.SendViz24(TimeDataSend(sumTwo));
                                        }
                                    }
                                    else
                                    {
                                        if (int.Parse(HmiaoTwo) < 10)
                                        {
                                            Hmiao = "0";
                                        }
                                        this.BeginInvoke(new EventHandler(delegate
                                        {
                                            txt_One_Data.Text = sumTwo;

                                            txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + "：  " + sumTwo + "----小于五秒只走时间 24秒不走----" + HmiaoTwo + "\r\n");
                                        }));
                                        //给Viz发送数据
                                        if (sendCommend != null)
                                        {
                                            sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
                                        }
                                    }
                                }


                                //给Viz发送数据
                                //if (sendCommend != null)
                                //{
                                //    sendCommend.SendViz24(TimeDataSend(sumTwo));
                                //}
                            }
                            
                            //01 01状态码清屏
                            if(buffer[0].ToString("X2") == "01" && buffer[1].ToString("X2") == "01" && buffer[3]<=24)
                            {
                                this.BeginInvoke(new EventHandler(delegate
                                {
                                    IsQP = true;
                                    WuMiao = false;
                                    txt_ALL_Data.AppendText(DateTime.Now.ToString("HH-mm-ss-fff") + ":0101状态清屏\r\n");
                                }));
                                if (sendCommend != null)
                                {
                                    sendCommend.SendViz24(TimeDataSend(" "));
                                }
                            }
                            #endregion
                        }
                        //24秒

                    }
                    else
                    {
                        Thread.Sleep(1);
                    }
                    #endregion
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                    LogMsg.WriteErrLogMsg("当前运行的逻辑进Cath：" + ex.Message);
                }
             
            }

        }
        #region 早先队列处理
//         if (HoseQueue.Count >= 1)
//                    {
//                        if (buffer == null)
//                        {
//                            buffer = HoseQueue.Dequeue();
//                        }
//    buffer2 = HoseQueue.Dequeue();
//                        if (buffer[5] != buffer2[5] && buffer[5] > 5)
//                        {
//                            if (buffer[1] == 0 || buffer[1] == 21 || buffer[1] == 08)
//                            {

//                                string sumTwo = buffer[5].ToString();
//    //24秒之后的毫秒
//    string Hmiao = buffer[4].ToString();
//                                //string str = Encoding.UTF8.GetString(buffer, 1, r - 1);
//                                if (int.Parse(sumTwo) >= 5)
//                                {
//                                    if (buffer[0] == 0 && buffer[1] == 0 && buffer[4] == 0 || buffer[5] == 14)
//                                    {
//                                        this.BeginInvoke(new EventHandler(delegate
//                                        {
//                                            txt_One_Data.Text = sumTwo;

//                                            txt_ALL_Data.AppendText(sumTwo + "--------" + Hmiao + "\r\n");
//                                            //给Viz发送数据
//                                            if (sendCommend != null)
//                                            {
//                                                sendCommend.SendViz24(TimeDataSend(sumTwo));
//                                            }
//                                        }));
//                                    }
//                                    else
//{
//    this.BeginInvoke(new EventHandler(delegate
//    {
//        txt_One_Data.Text = sumTwo;

//        txt_ALL_Data.AppendText(sumTwo + "--------" + Hmiao + "\r\n");
//        //给Viz发送数据
//        if (sendCommend != null)
//        {
//            sendCommend.SendViz24(TimeDataSend(sumTwo));
//        }
//    }));
//}


//                                }

//                            }
//                            buffer = buffer2;
//Thread.Sleep(680);
//                        }
//                        else
//{
//    string sumTwo = buffer[5].ToString();
//    //24秒之后的毫秒
//    string Hmiao = buffer[4].ToString();
//    Hmiao = Hmiao.Substring(0, 1);

//    if (int.Parse(sumTwo) < 5)
//    {
//        Hmiao = Hmiao.Substring(0, 1);
//        this.BeginInvoke(new EventHandler(delegate
//        {
//            txt_One_Data.Text = sumTwo + "." + Hmiao;
//            txt_ALL_Data.AppendText(sumTwo + "." + Hmiao + "\r\n");
//        }));
//        //给Viz发送数据
//        if (sendCommend != null)
//        {
//            sendCommend.SendViz24(TimeDataSend(sumTwo + "." + Hmiao));
//        }
//    }
//    if (buffer[5] == 14 || buffer[5] == 24 && buffer[1] == 0)
//    {
//        this.BeginInvoke(new EventHandler(delegate
//        {
//            txt_One_Data.Text = buffer[5].ToString();
//            txt_ALL_Data.AppendText(buffer[5] + "." + Hmiao + "\r\n");
//        }));
//        //给Viz发送数据
//        if (sendCommend != null)
//        {
//            sendCommend.SendViz24(TimeDataSend(buffer[5].ToString()));
//        }
//    }
//    buffer = buffer2;
//}

//                    }
//                    else
//{
//    if (buffer != null)
//    {
//        if (buffer[1] == 18 || buffer[1] == 10 || buffer[1] == 11 || buffer[1] == 14 || buffer[1] == 1)
//        {
//            if (sendCommend != null)
//            {
//                sendCommend.SendViz24(TimeDataSend(""));
//            }
//        }
//    }

//    //给Viz发送数据
//    //if (sendCommend != null)
//    //{
//    //    sendCommend.SendViz24(TimeDataSend(" "));
//    //}
//    Thread.Sleep(1);
//}
#endregion

public void CloseSocket()
        {
            try
            {
                if (socket == null)
                    return;

                if (!socket.Connected)
                    return;

                try
                {
                    socket.Shutdown(SocketShutdown.Both);
                }
                catch
                {
                }

                try
                {
                    socket.Close();
                }
                catch
                {
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }

        }
        #endregion

        #region 自定义串口代码
        public static SerialPort serialPort = new SerialPort();



        public void setPort()
        {
            serialPort.PortName = com_ComName.Text;
            serialPort.BaudRate = int.Parse(txt_BaudRate.Text);
            if (serialPort.IsOpen == false)
            {
                serialPort.Open();
            }
            //serialPort.DataReceived += new SerialDataReceivedEventHandler(_serialPort_DataReceived);
            threadSocket = new Thread(SerialPortShow);
            threadSocket.IsBackground = true;
            threadSocket.Start();
            threadSocket = new Thread(SokcetDempo);
            threadSocket.IsBackground = true;
            threadSocket.Start();

           
        }
        public void SerialPortShow()
        {
            serialPort.DataReceived += new SerialDataReceivedEventHandler(_serialPort_DataReceived);
        }


        private void _serialPort_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            try
            {
                bool temp = false;
                int tempCt = 0;
                string text = "";
                string strText = "";
                //防止读取不全的情况 等待10ms
                Thread.Sleep(10);
                byte[] buffer2 = new byte[20];//获取缓冲区的的字节数
                //int reslut2 = serialPort.ReadByte();
                // buffer: 将输入写入到其中的字节数组。
                //   offset:要写入字节的 buffer 中的偏移量。
                //   count:最多读取的字节数。 如果 count 大于输入缓冲区中的字节数，则读取较少的字节。
                int reslut = serialPort.Read(buffer2, 0, buffer2.Length);
                //serialPort.ReadTo("CD");
                //if (reslut <= 0)
                //{
                //    return;
                //}
                //string strResult = Encoding.ASCII.GetString(m_recvBytes, 0, m_recvBytes.Length);//转换成字符串格式的

                byte[] buffer = new byte[20];
                for (int i = 0; i < buffer2.Length; i++)
                {
                    try
                    {
                        if (buffer2[i].ToString("X8").Replace("0", "") == "CD")
                        {
                            if (i == 8)
                            {
                                buffer = buffer2;
                                for (int k = 0; k <= 8; k++)
                                {
                                    try
                                    {
                                        text += buffer[k].ToString("X2") + " ";
                                        strText += buffer[k].ToString() + " ";
                                    }
                                    catch
                                    {
                                    }
                                }
                                break;
                            }
                            else
                            {
                                if (!temp)
                                {
                                    temp = true;
                                }
                                else
                                {
                                    temp = false;
                                    tempCt = 0;
                                    break;
                                }
                            }
                        }
                        if (temp)
                        {
                            buffer[tempCt] = buffer2[i + 1];
                            tempCt++;
                            text += buffer2[i + 1].ToString("X2") + " ";
                            strText += buffer2[i + 1].ToString() + " ";
                        }
                    }
                    catch (Exception ex)
                    {
                        LogMsg.WriteErrLogMsg("重置接受到的字节出错：" + ex.Message);
                    }
                }

                HoseQueue.Enqueue(buffer);
                this.BeginInvoke(new EventHandler(delegate
                {
                    try
                    {
                        //string TxtPath = @"D:\txt\txt123\";
                        string postPath = TxtPath + DateTime.Now.ToString("yyyy-MM-dd hh-mm") + ".log";
                        if (Directory.Exists(TxtPath) == false)
                        {
                            Directory.CreateDirectory(postPath);
                        }
                        else
                        {
                            //log.deleteLog(@"D:\txt");
                            using (System.IO.StreamWriter file = new System.IO.StreamWriter(postPath, true))
                            {
                                //string swTxt = BitConverter.ToString(buffer).Replace(" - ", "");
                                file.WriteLine(DateTime.Now.ToString("HH-mm-ss-fff") + ":   " + text + "         " + strText);
                                text = "";
                                strText = "";
                            }
                        }
                        if (txt_ALL_Data.TextLength > 20 * 10000)
                        {
                            txt_ALL_Data.Text = "";
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }
                }));




                //this.Invoke((EventHandler)(delegate
                //{
                //    //txt_Tcp_Com.Text = m_recvBytes[4].ToString();
                //    txt_One_Data.Text = buffer2[5].ToString();
                //    txt_ALL_Data.AppendText(buffer2[5] + "\r\n");
                //}));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }

        }

        private void but_Lock_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("确定要解锁吗?", "确认", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
            {
                button1.Enabled = true;
                button2.Enabled = true;
                button3.Enabled = true;
                but_Lock.Text = "锁住";

            }
            else
            {
                button1.Enabled = false;
                button2.Enabled = false;
                button3.Enabled = false;
                but_Lock.Text = "解锁";
            }
        }

        public void ClosePort()
        {
            try
            {
                if (serialPort.IsOpen == true)
                {
                    serialPort.Close();
                }
                //serialPort.DataReceived -= new SerialDataReceivedEventHandler(_serialPort_DataReceived);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }

        }

        #endregion

        /// <summary>
        /// 发送数据
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void but_Send_Data_Click(object sender, EventArgs e)
        {
            SetGreen(this.but_Send_Data);
            IsReceive = true;
        }


        Thread threadTwo;
        /// <summary>
        /// 停止发送
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void but_Stop_Data_Click(object sender, EventArgs e)
        {
            SetGreen(this.but_Stop_Data);
            IsReceive = false;
            //threadTwo = new Thread(SokcetDempo);
           
        }
        
    }
}
