﻿using DllToolLib;
using ErrMsg;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DemoTool.Tool
{
   public  class LogMsg
    {
        public static void WriteErrLogMsg(string msg)
        {
            try
            {

                //string path = string.Format("{0}\\err_{1}.log", ConfigurationManager.AppSettings["LogPath"].ToString(), DateTime.Now.ToString("yyyyMMdd"));
                string path = string.Format("{0}\\err_{1}.log", ConfigurationManager.AppSettings["LogPath"].ToString(), DateTime.Now.ToString("yyyyMMdd"));
                string log_item = string.Format("{0}:     {1}", DateTime.Now.ToString("hh:mm:ss"), "ChineseBridgeSystem、" + msg + "\r\n");
                DebugEventArgs d1 = new DebugEventArgs(DebugType.err, "DemoTool24S、" + msg);
                //Debug.OnRetrunDebug(d1);
                FileIO.WriteTextFile(log_item, path, true, Encoding.UTF8);
            }
            catch (Exception ex)
            {
                ; Console.WriteLine(ex.Message);
            }

        }

        public static void WriteDataLogMsg(string data, string msg)
        {
            try
            {
                string path = string.Format("{0}\\{1}data_{2}.log", ConfigurationManager.AppSettings["DataPath"].ToString(), data, DateTime.Now.ToString("yyyyMMdd"));
                string log_item = string.Format("{0}:     {1}", DateTime.Now.ToString("hh:mm:ss"), "ChineseBridgeSystem、" + msg + "\r\n");
                DebugEventArgs d1 = new DebugEventArgs(DebugType.err, "ChineseBridgeSystem、" + msg);
                //Debug.OnRetrunDebug(d1);
                FileIO.WriteTextFile(log_item, path, true, Encoding.UTF8);
            }
            catch (Exception ex)
            {
                ; Console.WriteLine(ex.Message);
            }
        }
    }
}
