﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace DemoTool.Tool
{
    public class TcpTool
    {
        Socket socket;  //定义一个Socket
        public  void SokcetCliet(string ip,string com)
        {
            try
            {
                socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
                socket.Connect(IPAddress.Parse(ip), int.Parse(com));

                ThreadPool.QueueUserWorkItem(OnSendOrReceive, socket);
                //this.but_Client.Enabled = false;
                //button1.Enabled = true;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
            

            //ShowMsg("连接成功");
        }

        private void OnSendOrReceive(object sk)
        {
            var socket = sk as Socket;
            while (true)
            {
                try
                {
                    //客户端连接成功后，服务器应该接受客户端发来的消息
                    byte[] buffer = new byte[1024 * 1024 * 5];
                    //char[] vs = new char[1024 * 1024 * 5];
                    //实际接收到的字节数组
                    int r = socket.Receive(buffer);
                    if (r == 0)
                    {
                        break;
                    }
                    if (buffer[0] == 0)
                    {
                        //Encoding.ASCII.GetBytes(vs, 1, r - 1);
                        string str = Encoding.UTF8.GetString(buffer, 1, r - 1);
                        //ShowMsg(socket.RemoteEndPoint + ":" + str);
                    }
                    else if (buffer[1] == 1)
                    {
                        SaveFileDialog save = new SaveFileDialog();
                        save.InitialDirectory = @"C:\Users\18502\Desktop";
                        save.Title = "请选择要保存的文件";
                        save.Filter = "所有文件|*.*";
                       
                    }
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                }

            }
        }
    }


//    public class Time 
//    {
//        namespace MyTimerDemo
//    {
//        public partial class Form1 : Form
//        {
//            #region 私有变量 定义
//            /// <summary>
//            /// 记录每次启动定时器的时间
//            /// </summary>
//            private DateTime startTime;
//            /// <summary>
//            /// 定时器已走时间
//            /// </summary>
//            private TimeSpan span;
//            /// <summary>
//            /// 记录每次暂停时定时器已走时间
//            /// </summary>
//            private TimeSpan pauseSpan;
//            /// <summary>
//            /// 时间（秒）
//            /// </summary>
//            private int time;
//            /// <summary>
//            /// 是否倒计时
//            /// </summary>
//            private bool bDown;
//            /// <summary>
//            /// 误差测试临时变量
//            /// </summary>
//            private int iCount = 0;
//            #endregion

//            public Form1()
//            {
//                InitializeComponent();
//                timer1.Interval = 1; //每毫秒执行一次
//                time = 0; //初始化时间

//                //倒计时设定，如果时间为0则正计时，否则倒计时
//                if (time == 0)
//                {
//                    bDown = false;
//                }
//                else
//                {
//                    bDown = true;
//                }
//                label1.Text = string.Format("00:00:{0}:000", time.ToString("00"));
//                label2.Text = time.ToString("00");
//            }
//            /// <summary>
//            /// 开始/暂停
//            /// </summary>
//            private void btnStartPause_Click(object sender, EventArgs e)
//            {
//                timer1.Enabled = !timer1.Enabled;
//                if (timer1.Enabled) //开始
//                {
//                    btnStartPause.Text = "Pause";

//                    //启动定时器，务必修改启动时间
//                    startTime = DateTime.Now;
//                }
//                else //暂停
//                {
//                    btnStartPause.Text = "Start";

//                    //暂停，记录定时器当前已走时间
//                    pauseSpan = span;
//                }
//            }
//            /// <summary>
//            /// 停止定时器
//            /// </summary>
//            private void btnStop_Click(object sender, EventArgs e)
//            {
//                timer1.Enabled = false;
//                btnStartPause.Enabled = true;
//                btnStartPause.Text = "Start";
//                pauseSpan = new TimeSpan(0); //将上次暂停 记录的已走时间清零
//                label1.Text = string.Format("00:00:{0}:000", time.ToString("00"));
//                label2.Text = time.ToString("00");
//            }

//            private void timer1_Tick(object sender, EventArgs e)
//            {
//                //刷新定时器已走时间
//                //注意务必加上 上次暂停记录的已走时间
//                span = (DateTime.Now - startTime).Add(pauseSpan);

//                if (bDown) //倒计时
//                {
//                    //若时间倒到0，定时器停止工作
//                    if (span.Ticks >= time * TimeSpan.TicksPerSecond)
//                    {
//                        btnStartPause.Enabled = false;
//                        timer1.Enabled = false;
//                    }
//                    else
//                    {
//                        DateTime spanDt = new DateTime(
//                            time * TimeSpan.TicksPerSecond - span.Ticks);
//                        label1.Text = spanDt.ToString("HH:mm:ss:fff");
//                        label2.Text = (time - span.TotalSeconds).ToString("00");
//                    }
//                }
//                else //正计时
//                {
//                    DateTime spanDt = new DateTime(span.Ticks);
//                    label1.Text = spanDt.ToString("HH:mm:ss:fff");
//                    label2.Text = span.TotalSeconds.ToString("00");

//                    //误差测试，在正计时进行 --> 简单、方便:)
//                    iCount += timer1.Interval;
//                    label3.Text = (iCount / 1000).ToString("00");
//                }
//            }
//        }
//    }
//}

}
