﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VizConnectC;

namespace DemoTool.Tool
{
    /// <summary>
    /// 表示vs与viz的一些联系操作
    /// </summary>
    class VizCommand
    {
        //实例化列表
        public List<VizEnginePool> _poolList = new List<VizEnginePool>();
        public List<bool> IsConnectVizList = new List<bool>();
        public List<string> EnableIPList = new List<string>();
        public VizEnginePool vizEnginePool = new VizEnginePool();
        public string EnbleIPOne;
        public bool IsConnectVizOne;

        /// <summary>
        /// 主备连接Viz
        /// hostList表示连接的引擎的列表
        /// </summary>
        public void ConnectViz(List<string> IPlist)
        {
            _poolList.Clear();
            EnableIPList.Clear();
            //遍历
            for (int i = 0; i < IPlist.Count; i++)
            {
                VizEnginePool _pool = new VizEnginePool();
                bool IsConnectViz = false;//别处用来判断是否与引擎处于连接状态
                _pool.Disconnect();
                _pool.CleanRendererList();
                _pool.AddRenderer(IPlist[i], 6100);
                if (_pool.Connect())
                {
                    IsConnectViz = true;
                    IsConnectVizOne = true;
                    EnableIPList.Add(IPlist[i]);
                }
                else
                {
                    IsConnectViz = false;
                }
                IsConnectVizList.Add(IsConnectViz);
                _poolList.Add(_pool);
            }
        }
        /// <summary>
        /// 单个连接Viz
        /// hostList表示连接的引擎的列表
        /// </summary>
        public void ConnectOneViz(string IPlist)
        {
            //VizEnginePool _pool = new VizEnginePool();
            bool IsConnectViz = false;//别处用来判断是否与引擎处于连接状态
            vizEnginePool.Disconnect();
            vizEnginePool.CleanRendererList();
            vizEnginePool.AddRenderer(IPlist, 6100);
            if (vizEnginePool.Connect())
            {
                IsConnectViz = true;
            }
            else
            {
                IsConnectViz = false;
            }
            IsConnectVizOne = IsConnectViz;

        }

        /// <summary>
        /// 下场动画
        /// </summary>
        public void Continue()
        {
            for (int i = 0; i < _poolList.Count; i++)
            {
                if (_poolList[i].IsConnected)
                {
                    _poolList[i].Send("RENDERER*STAGE CONTINUE");//播放动画
                }
            }
        }
        //加载场景发送数据
        public void SendViz24(string data)
        {
            for (int i = 0; i < _poolList.Count; i++)
            {
                try
                {
                    if (_poolList[i].IsConnected)
                    {
                        _poolList[i].Send("RENDERER SET_OBJECT SCENE*Arena/Scenes/VizArenaMain");
                        _poolList[i].Send("RENDERER*SCRIPT INVOKE Data " + "\"" + data + "\"");
                        //_poolList[i].Send("RENDERER*SCRIPT INVOKE GuangGao " + guangGaoPath);
                        //_poolList[i].Send("RENDERER*STAGE START");//播放动画
                    }
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                }
               
            }
        }
        /// <summary>
        /// 只发数据
        /// </summary>
        /// <param name="data"></param>
        public void SendViz24Two(string data)
        {
            for (int i = 0; i < _poolList.Count; i++)
            {
                if (_poolList[i].IsConnected)
                {
                    _poolList[i].Send("RENDERER*SCRIPT INVOKE Data " + "\"" + data + "\"");
                }
            }
        }
    }
}
