﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Shapes;
using VIZ.Framework.Common;
using VIZ.Framework.Core;

namespace VIZ.ElectricRabbit.Module
{
    /// <summary>
    /// 主视图模型
    /// </summary>
    public class MainViewModel : ViewModelBase
    {
        public MainViewModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.SettingCommand = new VCommand(this.Setting);
            this.MinCommand = new VCommand(this.Min);
            this.CloseCommand = new VCommand(this.Close);
        }

        // ================================================================================
        // Property
        // ================================================================================

        #region IsShowSettingView -- 是否显示设置视图

        private bool isShowSettingView = true;
        /// <summary>
        /// 是否显示设置视图
        /// </summary>
        public bool IsShowSettingView
        {
            get { return isShowSettingView; }
            set { isShowSettingView = value; this.RaisePropertyChanged(nameof(IsShowSettingView)); }
        }

        #endregion

        #region SettingViewModel -- 设置视图模型

        private SettingViewModel settingViewModel = new SettingViewModel();
        /// <summary>
        /// 设置视图模型
        /// </summary>
        public SettingViewModel SettingViewModel
        {
            get { return settingViewModel; }
            set { settingViewModel = value; this.RaisePropertyChanged(nameof(SettingViewModel)); }
        }

        #endregion

        // ================================================================================
        // Command
        // ================================================================================

        #region CloseCommand -- 关闭命令

        /// <summary>
        /// 关闭命令
        /// </summary>
        public VCommand CloseCommand { get; set; }

        /// <summary>
        /// 关闭
        /// </summary>
        private void Close()
        {
            MessageBoxExResult result = MessageBoxEx.ShowDialog("提示", "确定退出？", MessageBoxExButtons.YES_CANCEL, this.GetWindow());
            if (result != MessageBoxExResult.YES)
                return;

            this.GetWindow().Close();
        }

        #endregion

        #region MinCommand -- 最小化窗口命令

        /// <summary>
        /// 最小化窗口命令
        /// </summary>
        public VCommand MinCommand { get; set; }

        /// <summary>
        /// 最小化
        /// </summary>
        private void Min()
        {
            this.GetWindow().WindowState = WindowState.Minimized;
        }

        #endregion

        #region SettingCommand --  设置命令

        /// <summary>
        /// 设置命令
        /// </summary>
        public VCommand SettingCommand { get; set; }

        /// <summary>
        /// 设置
        /// </summary>
        private void Setting()
        {
            //SystemSettingView view = new SystemSettingView();
            //NoneWindow window = new NoneWindow(1200, 1000, view);
            //window.Owner = this.GetWindow();

            //window.ShowDialog();
        }

        #endregion

    }
}
