﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Connection;
using VIZ.ElectricRabbit.Domain;

namespace VIZ.ElectricRabbit.Connection
{
    /// <summary>
    /// 算法解释器 -- 目标检测
    /// </summary>
    public class AlgorithmProvider__detect : IAlgorithmPackageProvider
    {
        /// <summary>
        /// 信号
        /// <see cref="AlgorithmPackageSignal"/>
        /// </summary>
        public string Signal { get; } = AlgorithmPackageSignal.detect;

        /// <summary>
        /// 执行
        /// </summary>
        /// <param name="info">信息</param>
        public void Execute(ConnSingleJsonInfo info)
        {
            AlgorithmRecvPackage__detect package = Newtonsoft.Json.JsonConvert.DeserializeObject<AlgorithmRecvPackage__detect>(info.Json);

            AlgorithmDectectMessage msg = new AlgorithmDectectMessage();
            msg.target_bbox = package.target_bbox;
            msg.center_x = package.center_x;

            ApplicationDomainEx.MessageManager.Send(msg);
        }
    }
}
