﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;

namespace VIZ.ElectricRabbit.Domain
{
    /// <summary>
    /// 客户端配置信息
    /// </summary>
    public class ClientConfigInfo
    {
        /// <summary>
        /// 安全距离（单位：像素）
        /// </summary>
        public int SafeDistance { get; set; }

        /// <summary>
        /// 安全轴位置（单位：像素）
        /// </summary>
        public int SafeAxis { get; set; }

        /// <summary>
        /// 是否启用闪烁
        /// </summary>
        public bool IsFlashingEnabled { get; set; }

        /// <summary>
        /// 闪烁间隔
        /// </summary>
        public double FlashingInterval { get; set; }

        /// <summary>
        /// 方向向左颜色
        /// </summary>
        public Color LeftColor { get; set; }

        /// <summary>
        /// 方向向右颜色
        /// </summary>
        public Color RightColor { get; set; }

        /// <summary>
        /// 安全颜色
        /// </summary>
        public Color SafeColor { get; set; }
    }
}
