﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;
using VIZ.ElectricRabbit.Domain;
using VIZ.ElectricRabbit.Storage;
using VIZ.Framework.Core;
using VIZ.Framework.Domain;
using VIZ.Framework.Module;

namespace VIZ.ElectricRabbit.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化INI
    /// </summary>
    public class AppSetup_InitINI : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitINI));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化INI";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            // 安全距离
            ApplicationDomainEx.ClientConfigInfo.SafeDistance = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, int>(p => p.CLIENT_SAFE_DISTANCE);
            // 安全轴位置
            ApplicationDomainEx.ClientConfigInfo.SafeAxis = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, int>(p => p.CLIENT_SAFE_AXIS);
            // 是否启用闪烁
            ApplicationDomainEx.ClientConfigInfo.IsFlashingEnabled = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, bool>(p => p.CLIENT_IS_FLASHING_ENABLED);
            // 闪烁间隔
            ApplicationDomainEx.ClientConfigInfo.FlashingInterval = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, double>(p => p.CLIENT_FLASHING_INTERVAL);
            // 方向向左箭头颜色
            ApplicationDomainEx.ClientConfigInfo.LeftColor = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, Color>(p => p.CLIENT_LEFT_COLOR);
            // 方向向右箭头颜色
            ApplicationDomainEx.ClientConfigInfo.RightColor = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, Color>(p => p.CLIENT_RIGHT_COLOR);
            // 安全颜色
            ApplicationDomainEx.ClientConfigInfo.SafeColor = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, Color>(p => p.CLIENT_SAFE_COLOR);

            // 注册保存任务
            ApplicationDomainEx.LoopManager.Register("AppSetup_InitINI.saveIni", 30, this.saveIni);

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            this.saveIni();
        }

        /// <summary>
        /// 保存INI配置
        /// </summary>
        private void saveIni()
        {
            // 安全距离
            ApplicationDomainEx.IniStorage.SetValue<ClientConfig>(p => p.CLIENT_SAFE_DISTANCE, ApplicationDomainEx.ClientConfigInfo.SafeDistance);
            // 安全轴位置
            ApplicationDomainEx.IniStorage.SetValue<ClientConfig>(p => p.CLIENT_SAFE_AXIS, ApplicationDomainEx.ClientConfigInfo.SafeAxis);
            // 是否启用闪烁
            ApplicationDomainEx.IniStorage.SetValue<ClientConfig>(p => p.CLIENT_IS_FLASHING_ENABLED, ApplicationDomainEx.ClientConfigInfo.IsFlashingEnabled);
            // 闪烁间隔
            ApplicationDomainEx.IniStorage.SetValue<ClientConfig>(p => p.CLIENT_FLASHING_INTERVAL, ApplicationDomainEx.ClientConfigInfo.FlashingInterval);
            // 方向向左箭头颜色
            ApplicationDomainEx.IniStorage.SetValue<ClientConfig>(p => p.CLIENT_LEFT_COLOR, ApplicationDomainEx.ClientConfigInfo.LeftColor);
            // 方向向右箭头颜色
            ApplicationDomainEx.IniStorage.SetValue<ClientConfig>(p => p.CLIENT_RIGHT_COLOR, ApplicationDomainEx.ClientConfigInfo.RightColor);
            // 安全颜色
            ApplicationDomainEx.IniStorage.SetValue<ClientConfig>(p => p.CLIENT_SAFE_COLOR, ApplicationDomainEx.ClientConfigInfo.SafeColor);
        }
    }
}