﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;
using VIZ.ElectricRabbit.Connection;
using VIZ.ElectricRabbit.Domain;
using VIZ.ElectricRabbit.Storage;
using VIZ.Framework.Connection;
using VIZ.Framework.Core;
using VIZ.Framework.Domain;
using VIZ.Framework.Module;

namespace VIZ.ElectricRabbit.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化UDP
    /// </summary>
    public class AppSetup_InitUDP : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitUDP));

        /// <summary>
        /// UDP 绑定IP
        /// </summary>
        private readonly static string CLIENT_UDP_BINDING_IP = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, string>(p => p.CLIENT_UDP_BINDING_IP);

        /// <summary>
        /// UDP 绑定端口
        /// </summary>
        private readonly static int CLIENT_UDP_BINDING_PORT = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, int>(p => p.CLIENT_UDP_BINDING_PORT);

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化UDP";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            UdpConnection conn = new UdpConnection();

            conn.PackageProvider = new AlgorithmPackageProvider();
            conn.Binding(CLIENT_UDP_BINDING_IP, CLIENT_UDP_BINDING_PORT);

            ConnectionManager.UdpConnection = conn;

            conn.Start();

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            ConnectionManager.UdpConnection?.Dispose();
        }
    }
}