﻿using log4net;
using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Media;
using VIZ.ElectricRabbit.Connection;
using VIZ.ElectricRabbit.Domain;
using VIZ.ElectricRabbit.Storage;
using VIZ.Framework.Connection;
using VIZ.Framework.Core;
using VIZ.Framework.Domain;
using VIZ.Framework.Module;

namespace VIZ.ElectricRabbit.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化串口
    /// </summary>
    public class AppSetup_SerialPort : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_SerialPort));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 串口";

        /// <summary>
        /// 输出串口号
        /// </summary>
        private readonly string CLIENT_OUTPUT_SERIAL_PORT = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, string>(p => p.CLIENT_OUTPUT_SERIAL_PORT);

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            ConnectionManager.SerialPortConnection = new SerialPortConnection();

            try
            {
                SerialPortEndpointManager down_endpoint_manager = new SerialPortEndpointManager(SerialPortKeys.Output, CLIENT_OUTPUT_SERIAL_PORT, 115200, Parity.None, 8, StopBits.One);
                //down_endpoint_manager.PackageProvider = new GimbalPackageDownProvider(53, new byte[] { 0xA5, 0xE7 }, SerialPortKeys.Output);
                ConnectionManager.SerialPortConnection.AddEndpointManager(down_endpoint_manager);

                down_endpoint_manager.Open();
            }
            catch (Exception ex)
            {
                // 串口打开失败只需要记录日志
                log.Error(ex);
            }

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            ConnectionManager.SerialPortConnection.Dispose();
        }
    }
}