﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Remoting.Contexts;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Media.Media3D;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;

namespace VIZ.ElectricRabbit.Common
{
    /// <summary>
    /// 箭头控件
    /// </summary>
    public class ArrowShape : Shape
    {
        #region DifferenceSafeValue -- 安全值

        /// <summary>
        /// 安全值
        /// </summary>
        public int DifferenceSafeValue
        {
            get { return (int)GetValue(DifferenceSafeValueProperty); }
            set { SetValue(DifferenceSafeValueProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for DifferenceSafeValue.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty DifferenceSafeValueProperty =
            DependencyProperty.Register("DifferenceSafeValue", typeof(int), typeof(ArrowShape), new PropertyMetadata(0));

        #endregion

        #region DifferenceValue -- 差值

        /// <summary>
        /// 差值
        /// </summary>
        public int DifferenceValue
        {
            get { return (int)GetValue(DifferenceValueProperty); }
            set { SetValue(DifferenceValueProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for DifferenceValue.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty DifferenceValueProperty =
            DependencyProperty.Register("DifferenceValue", typeof(int), typeof(ArrowShape), new PropertyMetadata(0, new PropertyChangedCallback((s, e) =>
            {
                (s as ArrowShape).InvalidateVisual();
            })));

        #endregion

        #region DifferenceMaxValue -- 差值最大值

        /// <summary>
        /// 差值最大值
        /// </summary>
        public int DifferenceMaxValue
        {
            get { return (int)GetValue(DifferenceMaxValueProperty); }
            set { SetValue(DifferenceMaxValueProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for DifferenceMaxValue.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty DifferenceMaxValueProperty =
            DependencyProperty.Register("DifferenceMaxValue", typeof(int), typeof(ArrowShape), new PropertyMetadata(1920));

        #endregion

        #region IsDifferenceValueSafe -- 差值是否安全

        /// <summary>
        /// 差值是否安全
        /// </summary>
        public bool IsDifferenceValueSafe
        {
            get { return (bool)GetValue(IsDifferenceValueSafeProperty); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for IsDifferenceValueSafe.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyPropertyKey IsDifferenceValueSafePropertyKey =
            DependencyProperty.RegisterReadOnly("IsDifferenceValueSafe", typeof(bool), typeof(ArrowShape), new PropertyMetadata(true));

        /// <summary>
        /// Using a DependencyProperty as the backing store for IsDifferenceValueSafe.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty IsDifferenceValueSafeProperty = IsDifferenceValueSafePropertyKey.DependencyProperty;

        #endregion

        #region ArrowMaxWidth -- 箭头最大宽度

        /// <summary>
        /// 箭头最大宽度
        /// </summary>
        public double ArrowMaxWidth
        {
            get { return (double)GetValue(ArrowMaxWidthProperty); }
            set { SetValue(ArrowMaxWidthProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for ArrowMaxWidth.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty ArrowMaxWidthProperty =
            DependencyProperty.Register("ArrowMaxWidth", typeof(double), typeof(ArrowShape), new PropertyMetadata(20d));



        #endregion

        #region ArrowMaxHeight -- 箭头最大高度

        /// <summary>
        /// 箭头最大高度
        /// </summary>
        public double ArrowMaxHeight
        {
            get { return (double)GetValue(ArrowMaxHeightProperty); }
            set { SetValue(ArrowMaxHeightProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for ArrowMaxHeight.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty ArrowMaxHeightProperty =
            DependencyProperty.Register("ArrowMaxHeight", typeof(double), typeof(ArrowShape), new PropertyMetadata(20d));

        #endregion

        #region ArrowMinWidth -- 箭头最小宽度

        /// <summary>
        /// 箭头最小宽度
        /// </summary>
        public double ArrowMinWidth
        {
            get { return (double)GetValue(ArrowMinWidthProperty); }
            set { SetValue(ArrowMinWidthProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for ArrowMinWidth.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty ArrowMinWidthProperty =
            DependencyProperty.Register("ArrowMinWidth", typeof(double), typeof(ArrowShape), new PropertyMetadata(5d));

        #endregion

        #region ArrowMinHeigh -- 箭头最小高度

        /// <summary>
        /// 箭头最小高度
        /// </summary>
        public double ArrowMinHeigh
        {
            get { return (double)GetValue(ArrowMinHeighProperty); }
            set { SetValue(ArrowMinHeighProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for ArrowMinHeigh.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty ArrowMinHeighProperty =
            DependencyProperty.Register("ArrowMinHeigh", typeof(double), typeof(ArrowShape), new PropertyMetadata(5d));

        #endregion

        #region RectangleMinWidth -- 矩形最小宽度

        /// <summary>
        /// 矩形最小宽度
        /// </summary>
        public double RectangleMinWidth
        {
            get { return (double)GetValue(RectangleMinWidthProperty); }
            set { SetValue(RectangleMinWidthProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for RectangleMinWidth.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty RectangleMinWidthProperty =
            DependencyProperty.Register("RectangleMinWidth", typeof(double), typeof(ArrowShape), new PropertyMetadata(5d));

        #endregion

        #region RectangleMinHeigh -- 矩形最小高度

        /// <summary>
        /// 矩形最小高度
        /// </summary>
        public double RectangleMinHeigh
        {
            get { return (double)GetValue(RectangleMinHeighProperty); }
            set { SetValue(RectangleMinHeighProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for RectangleMinHeigh.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty RectangleMinHeighProperty =
            DependencyProperty.Register("RectangleMinHeigh", typeof(double), typeof(ArrowShape), new PropertyMetadata(3d));

        #endregion

        #region RectangleMaxWidth -- 矩形最大宽度

        /// <summary>
        /// 矩形最大宽度
        /// </summary>
        public double RectangleMaxWidth
        {
            get { return (double)GetValue(RectangleMaxWidthProperty); }
            set { SetValue(RectangleMaxWidthProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for RectangleMaxWidth.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty RectangleMaxWidthProperty =
            DependencyProperty.Register("RectangleMaxWidth", typeof(double), typeof(ArrowShape), new PropertyMetadata(500d));

        #endregion

        #region RectangleMaxHeigh -- 矩形最大高度

        /// <summary>
        /// 矩形最大高度
        /// </summary>
        public double RectangleMaxHeigh
        {
            get { return (double)GetValue(RectangleMaxHeighProperty); }
            set { SetValue(RectangleMaxHeighProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for RectangleMaxHeigh.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty RectangleMaxHeighProperty =
            DependencyProperty.Register("RectangleMaxHeigh", typeof(double), typeof(ArrowShape), new PropertyMetadata(50d));

        #endregion

        #region RectangleHeightProportion -- 矩形高度占比（相对于箭头）

        /// <summary>
        /// 矩形高度占比（相对于箭头）
        /// </summary>
        public double RectangleHeightProportion
        {
            get { return (double)GetValue(RectangleHeightProportionProperty); }
            set { SetValue(RectangleHeightProportionProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for RectangleHeightProportion.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty RectangleHeightProportionProperty =
            DependencyProperty.Register("RectangleHeightProportion", typeof(double), typeof(ArrowShape), new PropertyMetadata(0.5d));

        #endregion

        #region SafeRectangleWidth -- 安全矩形宽度

        /// <summary>
        /// 安全矩形宽度
        /// </summary>
        public double SafeRectangleWidth
        {
            get { return (double)GetValue(SafeRectangleWidthProperty); }
            set { SetValue(SafeRectangleWidthProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for SafeRectangleWidth.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty SafeRectangleWidthProperty =
            DependencyProperty.Register("SafeRectangleWidth", typeof(double), typeof(ArrowShape), new PropertyMetadata(100d));

        #endregion

        #region SafeRectangleHeight -- 安全矩形高度

        /// <summary>
        /// 安全矩形高度
        /// </summary>
        public double SafeRectangleHeight
        {
            get { return (double)GetValue(SafeRectangleHeightProperty); }
            set { SetValue(SafeRectangleHeightProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for SafeRectangleHeight.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty SafeRectangleHeightProperty =
            DependencyProperty.Register("SafeRectangleHeight", typeof(double), typeof(ArrowShape), new PropertyMetadata(60d));

        #endregion

        #region SafeBrush -- 安全矩形画刷

        /// <summary>
        /// 安全矩形画刷
        /// </summary>
        public Brush SafeBrush
        {
            get { return (Brush)GetValue(SafeBrushProperty); }
            set { SetValue(SafeBrushProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for SafeBrush.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty SafeBrushProperty =
            DependencyProperty.Register("SafeBrush", typeof(Brush), typeof(ArrowShape), new PropertyMetadata(Brushes.Green));

        #endregion

        #region RightBrush -- 向右画刷

        /// <summary>
        /// 向右画刷
        /// </summary>
        public Brush RightBrush
        {
            get { return (Brush)GetValue(RightBrushProperty); }
            set { SetValue(RightBrushProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for RightBrush.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty RightBrushProperty =
            DependencyProperty.Register("RightBrush", typeof(Brush), typeof(ArrowShape), new PropertyMetadata(Brushes.Red));

        #endregion

        #region LeftBrush -- 向左画刷

        /// <summary>
        /// 向左画刷
        /// </summary>
        public Brush LeftBrush
        {
            get { return (Brush)GetValue(LeftBrushProperty); }
            set { SetValue(LeftBrushProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for LeftBrush.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty LeftBrushProperty =
            DependencyProperty.Register("LeftBrush", typeof(Brush), typeof(ArrowShape), new PropertyMetadata(Brushes.Yellow));

        #endregion

        /// <summary>
        /// 定义形状
        /// </summary>
        protected override Geometry DefiningGeometry => this.RenderSafe();

        /// <summary>
        /// 绘制
        /// </summary>
        /// <param name="drawingContext">绘制上下文</param>
        protected override void OnRender(DrawingContext drawingContext)
        {
            // 安全区域
            if (Math.Abs(this.DifferenceValue) < this.DifferenceSafeValue)
            {
                StreamGeometry geometry = this.RenderSafe();
                drawingContext.DrawGeometry(this.SafeBrush, null, geometry);
            }
            // 向右箭头
            else if (this.DifferenceValue > 0)
            {
                StreamGeometry geometry = this.RenderArrow(this.DifferenceValue, false);
                drawingContext.DrawGeometry(this.RightBrush, null, geometry);
            }
            // 向左箭头
            else
            {
                StreamGeometry geometry = this.RenderArrow(-this.DifferenceValue, true);
                drawingContext.DrawGeometry(this.LeftBrush, null, geometry);
            }
        }

        /// <summary>
        /// 绘制安全图形
        /// </summary>
        /// <param name="drawingContext">绘制上下文</param>
        /// <returns>图形</returns>
        private StreamGeometry RenderSafe()
        {
            // ---------------------------------------------------------------------
            // 绘制坐标 
            // -------------------------------------------------------
            //   (x1, y1) -------------------- (x2, y2)
            //      |                              |   
            //   (x4, y4) -------------------- (x3, y3)
            // ---------------------------------------------------------------------

            // (x1, y1)
            double x1 = (this.ActualWidth - this.SafeRectangleWidth) / 2d;
            double y1 = (this.ActualHeight - this.SafeRectangleHeight) / 2d;

            // (x2, y2)
            double x2 = x1 + this.SafeRectangleWidth;
            double y2 = y1;

            // (x3, y3)
            double x3 = x2;
            double y3 = y2 + this.SafeRectangleHeight;

            // (x4, y4)
            double x4 = x1;
            double y4 = y1 + this.SafeRectangleHeight;

            StreamGeometry geometry = new StreamGeometry();
            using (StreamGeometryContext ctx = geometry.Open())
            {
                ctx.BeginFigure(new Point(x1, y1), true, true);
                ctx.LineTo(new Point(x2, y2), false, false);
                ctx.LineTo(new Point(x3, y3), false, false);
                ctx.LineTo(new Point(x4, y4), false, false);
                ctx.LineTo(new Point(x1, y1), false, false);
            }

            return geometry;
        }

        /// <summary>
        /// 绘制方向向右的箭头
        /// </summary>
        /// <param name="differenceValue">差值绝对值</param>
        /// <param name="isFlip">是否水平翻转</param>
        /// <returns>形状</returns>
        private StreamGeometry RenderArrow(double differenceValue, bool isFlip)
        {
            // ---------------------------------------------------------------------
            // 差值占比
            // ---------------------------------------------------------------------
            double p = (double)differenceValue / (double)this.DifferenceMaxValue;
            p = p > 1 ? 1 : p;

            // ---------------------------------------------------------------------
            // 绘制返回
            // ---------------------------------------------------------------------

            // 箭头的可绘制区域
            double arrow_container_width = this.ArrowMaxWidth;
            double arrow_container_heigh = this.ActualHeight;

            // 箭头的大小
            double arrow_width = arrow_container_width * p;
            double arrow_heigh = arrow_container_heigh * p;
            arrow_width = MathHelper.Clip(this.ArrowMinWidth, this.ArrowMaxWidth, arrow_width);
            arrow_heigh = MathHelper.Clip(this.ArrowMinHeigh, this.ArrowMaxHeight, arrow_heigh);

            // 矩形的可绘制区域
            double rect_container_width = this.ActualWidth - this.ArrowMaxWidth;
            double rect_container_heigh = this.ActualHeight;

            // 矩形的大小
            double rect_width = rect_container_width * p;
            double rect_heigh = arrow_heigh * this.RectangleHeightProportion;
            rect_width = MathHelper.Clip(this.RectangleMinWidth, this.RectangleMaxWidth, rect_width);

            // ---------------------------------------------------------------------
            // 绘制坐标 
            // -------------------------------------------------------
            //                                 (x3, y3)
            //                                     |    \
            //   (x1, y1) -------------------- (x2, y2)    \
            //      |                                      (x4, y4)
            //   (x7, y7) -------------------- (x6, y6)    /
            //                                     |    /
            //                                 (x5, y5)
            // ---------------------------------------------------------------------

            // (x1, y1)
            double x1 = (rect_container_width - rect_width) / 2d;
            double y1 = (rect_container_heigh - rect_heigh) / 2d;

            // (x2, y2)
            double x2 = x1 + rect_width;
            double y2 = y1;

            // (x3, y3)
            double x3 = x2;
            double y3 = (arrow_container_heigh - arrow_heigh) / 2d;

            // (x4, y4)
            double x4 = x2 + arrow_width;
            double y4 = y3 + arrow_heigh / 2d;

            // (x5, y5)
            double x5 = x2;
            double y5 = arrow_heigh + (arrow_container_heigh - arrow_heigh) / 2d;

            // (x6, y6)
            double x6 = x2;
            double y6 = y2 + rect_heigh;

            // (x7, y7)
            double x7 = x1;
            double y7 = y1 + rect_heigh;

            // x 坐标翻转
            if (isFlip)
            {
                x1 = this.ActualWidth - x1;
                x2 = this.ActualWidth - x2;
                x3 = this.ActualWidth - x3;
                x4 = this.ActualWidth - x4;
                x5 = this.ActualWidth - x5;
                x6 = this.ActualWidth - x6;
                x7 = this.ActualWidth - x7;
            }

            StreamGeometry geometry = new StreamGeometry();
            using (StreamGeometryContext ctx = geometry.Open())
            {
                ctx.BeginFigure(new Point(x1, y1), true, true);
                ctx.LineTo(new Point(x2, y2), false, false);
                ctx.LineTo(new Point(x3, y3), false, false);
                ctx.LineTo(new Point(x4, y4), false, false);
                ctx.LineTo(new Point(x5, y5), false, false);
                ctx.LineTo(new Point(x6, y6), false, false);
                ctx.LineTo(new Point(x7, y7), false, false);
                ctx.LineTo(new Point(x1, y1), false, false);
            }

            return geometry;
        }

    }
}
