﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using log4net;
using VIZ.Framework.Connection;

namespace VIZ.ElectricRabbit.Connection
{
    /// <summary>
    /// 算法单条消息为json的解析器
    /// </summary>
    public class AlgorithmPackageProvider : ConnSingleJsonPackageProvider
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AlgorithmPackageProvider));

        public AlgorithmPackageProvider()
        {
            // 算法检测
            this.providers.Add(new AlgorithmProvider__detect());
        }

        /// <summary>
        /// 算法数据包处理器
        /// </summary>
        private List<IAlgorithmPackageProvider> providers = new List<IAlgorithmPackageProvider>();

        /// <summary>
        /// 执行
        /// </summary>
        /// <param name="info">信息</param>
        protected override void Execute(ConnSingleJsonInfo info)
        {
            Task.Run(() =>
            {
                try
                {
                    AlgorithmPackageBase @base = Newtonsoft.Json.JsonConvert.DeserializeObject<AlgorithmPackageBase>(info.Json);

                    foreach (IAlgorithmPackageProvider provider in this.providers)
                    {
                        if (string.Equals(provider.Signal, @base.signal))
                        {
                            provider.Execute(info);

                            break;
                        }
                    }
                }
                catch (Exception ex)
                {
                    log.Error(ex);
                }
            });
        }
    }
}
