﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.ElectricRabbit.Connection;
using VIZ.ElectricRabbit.Domain;
using VIZ.Framework.Connection;
using VIZ.Framework.Core;

namespace VIZ.ElectricRabbit.Module
{
    /// <summary>
    /// 输出控制器
    /// </summary>
    public class OutputController : IDisposable
    {
        /// <summary>
        /// 发送间隔，单位：毫秒
        /// </summary>
        public const int SEND_WAIT = 10;

        /// <summary>
        /// 输出控制器
        /// </summary>
        /// <param name="support">支持</param>
        public OutputController(IOutputSupport support)
        {
            this.Support = support;

            ApplicationDomainEx.ObjectPoolManager.Add("VIZ.ElectricRabbit.Module.OutputController", this);
        }

        /// <summary>
        /// 支持
        /// </summary>
        public IOutputSupport Support { get; private set; }

        /// <summary>
        /// 任务信息
        /// </summary>
        private TaskInfo taskInfo;

        /// <summary>
        /// 任务
        /// </summary>
        private Task task;

        /// <summary>
        /// 心跳指令
        /// </summary>
        private int heart;

        /// <summary>
        /// 启动输出控制
        /// </summary>
        public void Start()
        {
            this.taskInfo = new TaskInfo();
            this.task = Task.Run(this.Execute);
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            if (this.taskInfo != null)
            {
                this.taskInfo.IsCancel = true;
            }

            this.taskInfo = null;
            this.task = null;
        }

        /// <summary>
        /// 执行
        /// </summary>
        private void Execute()
        {
            TaskInfo taskInfo = this.taskInfo;

            while (!taskInfo.IsCancel)
            {
                if (ConnectionManager.SerialPortConnection == null)
                {
                    System.Threading.Thread.Sleep(SEND_WAIT);
                    continue;
                }

                SerialPortEndpointManager endpoint = ConnectionManager.SerialPortConnection.GetEndpointManager(SerialPortKeys.Output);
                if (endpoint == null)
                {
                    System.Threading.Thread.Sleep(SEND_WAIT);
                    continue;
                }

                OutputPackage_data package = new OutputPackage_data();
                package.SyncHead_1 = 0xA5;
                package.SyncHead_2 = 0x2F;
                package.HelpCommand_PN = this.Support.AlgorithmDifferenceValue < 0 ? (byte)1 : (byte)0;
                package.HelpCommand = (UInt16)Math.Abs(this.Support.AlgorithmDifferenceValue);
                package.Heart = (byte)this.heart;
                package.Check = package.GetCheckValue();

                this.heart++;
                if (this.heart > 255)
                {
                    this.heart = 0;
                }

                endpoint.Send(package.ToBuffer());

                System.Threading.Thread.Sleep(SEND_WAIT);
            }
        }
    }
}
