﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;
using VIZ.ElectricRabbit.Domain;
using VIZ.ElectricRabbit.Storage;
using VIZ.Framework.Common;
using VIZ.Framework.Core;
using VIZ.Framework.Domain;
using VIZ.Framework.Module;

namespace VIZ.ElectricRabbit.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化OpenCV
    /// </summary>
    public class AppSetup_InitOpenCV : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitOpenCV));

        /// <summary>
        /// OpenCV流索引
        /// </summary>
        private readonly static int CLIENT_OPEN_CV_STREAM_INDEX = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, int>(p => p.CLIENT_OPEN_CV_STREAM_INDEX);

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化OpenCV";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            OpenCVStreamOption option = new OpenCVStreamOption();
            OpenCVStream stream = new OpenCVStream(CLIENT_OPEN_CV_STREAM_INDEX, option);

            VideoStreamManager.Append(VideoViewKeys.Main, stream);

            Task.Run(() =>
            {
                stream.Start();
            });

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            OpenCVStream stream = VideoStreamManager.Get<OpenCVStream>(VideoViewKeys.Main);

            stream?.Dispose();
        }
    }
}