﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;
using VIZ.Framework.Storage;

namespace VIZ.ElectricRabbit.Storage
{
    /// <summary>
    /// 客户端配置
    /// </summary>
    public class ClientConfig : IniConfigBase
    {
        /// <summary>
        /// OpenCV流索引
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "1", Type = typeof(int))]
        public string CLIENT_OPEN_CV_STREAM_INDEX { get; set; }

        /// <summary>
        /// 绑定IP
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "127.0.0.1", Type = typeof(string))]
        public string CLIENT_UDP_BINDING_IP { get; set; }

        /// <summary>
        /// 绑定端口
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "8701", Type = typeof(int))]
        public string CLIENT_UDP_BINDING_PORT { get; set; }

        /// <summary>
        /// 安全范围（单位：像素）
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "200", Type = typeof(int))]
        public string CLIENT_SAFE_DISTANCE { get; set; }

        /// <summary>
        /// 安全轴位置（单位：像素）
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "200", Type = typeof(int))]
        public string CLIENT_SAFE_AXIS { get; set; }

        /// <summary>
        /// 是否使用闪烁
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "false", Type = typeof(bool))]
        public string CLIENT_IS_FLASHING_ENABLED { get; set; }

        /// <summary>
        /// 闪烁间隔（单位：秒）
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "1", Type = typeof(double))]
        public string CLIENT_FLASHING_INTERVAL { get; set; }

        /// <summary>
        /// 箭头向左颜色（格式：#AARRGGBB）
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "#FF0000FF", Type = typeof(Color))]
        public string CLIENT_LEFT_COLOR { get; set; }

        /// <summary>
        /// 箭头向右颜色（格式：#AARRGGBB）
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "#FFFF0000", Type = typeof(Color))]
        public string CLIENT_RIGHT_COLOR { get; set; }

        /// <summary>
        /// 箭头安全颜色（格式：#AARRGGBB）
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "#FF00FF00", Type = typeof(Color))]
        public string CLIENT_SAFE_COLOR { get; set; }

        /// <summary>
        /// 输出串口号
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "COM1", Type = typeof(string))]
        public string CLIENT_OUTPUT_SERIAL_PORT { get; set; }
    }
}
