﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;
using VIZ.ElectricRabbit.Module;
using VIZ.Framework.Module;

namespace VIZ.ElectricRabbit
{
    /// <summary>
    /// App.xaml 的交互逻辑
    /// </summary>
    public partial class App : Application
    {
        public App()
        {
            // 初始化 INI
            AppSetup.AppendSetup(new AppSetup_InitINI());
            // 初始化OpenCV
            AppSetup.AppendSetup(new AppSetup_InitOpenCV());
            // 初始化UDP
            AppSetup.AppendSetup(new AppSetup_InitUDP());
            // 初始化串口
            AppSetup.AppendSetup(new AppSetup_SerialPort());

            // 执行启动流程
            AppSetupContext context = AppSetup.Setup();

            if (context.Exception != null)
            {
                MessageBox.Show($"执行 {context.ProviderDetail} 失败\r\n{context.Exception.Message}");
            }

            if (!context.IsSuccess)
            {
                Environment.Exit(-1);
            }
        }
    }
}
