﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Configuration;
using System.Web.UI.HtmlControls;
using System.Windows.Media;
using VIZ.ElectricRabbit.Domain;
using VIZ.ElectricRabbit.Storage;
using VIZ.Framework.Common;
using VIZ.Framework.Core;

namespace VIZ.ElectricRabbit.Module
{
    /// <summary>
    /// 设置视图模型
    /// </summary>
    public class SettingViewModel : ViewModelBase
    {
        #region SafeDistance -- 安全距离（单位：像素）

        private int safeDistance = ApplicationDomainEx.ClientConfigInfo.SafeDistance;
        /// <summary>
        /// 安全距离（单位：像素）
        /// </summary>
        public int SafeDistance
        {
            get { return safeDistance; }
            set
            {
                safeDistance = value;
                this.RaisePropertyChanged(nameof(SafeDistance));
                ApplicationDomainEx.ClientConfigInfo.SafeDistance = value;
            }
        }

        #endregion

        #region SafeAxis -- 安全轴位置（单位：像素）

        private int safeAxis = ApplicationDomainEx.ClientConfigInfo.SafeAxis;
        /// <summary>
        /// 安全轴位置（单位：像素）
        /// </summary>
        public int SafeAxis
        {
            get { return safeAxis; }
            set
            {
                safeAxis = value;
                this.RaisePropertyChanged(nameof(SafeAxis));
                ApplicationDomainEx.ClientConfigInfo.SafeAxis = value;
            }
        }

        #endregion

        #region IsFlashingEnabled -- 是否启用闪烁

        private bool isFlashingEnabled = ApplicationDomainEx.ClientConfigInfo.IsFlashingEnabled;
        /// <summary>
        /// 是否启用闪烁
        /// </summary>
        public bool IsFlashingEnabled
        {
            get { return isFlashingEnabled; }
            set
            {
                isFlashingEnabled = value;
                this.RaisePropertyChanged(nameof(IsFlashingEnabled));
                ApplicationDomainEx.ClientConfigInfo.IsFlashingEnabled = value;
            }
        }

        #endregion

        #region FlashingInterval -- 闪烁间隔

        private double flashingInterval = ApplicationDomainEx.ClientConfigInfo.FlashingInterval;
        /// <summary>
        /// 闪烁间隔
        /// </summary>
        public double FlashingInterval
        {
            get { return flashingInterval; }
            set
            {
                flashingInterval = value;
                this.RaisePropertyChanged(nameof(FlashingInterval));
                ApplicationDomainEx.ClientConfigInfo.FlashingInterval = value;
            }
        }

        #endregion

        #region LeftColor -- 方向向左颜色

        private Color leftColor = ApplicationDomainEx.ClientConfigInfo.LeftColor;
        /// <summary>
        /// 方向向左颜色
        /// </summary>
        public Color LeftColor
        {
            get { return leftColor; }
            set
            {
                leftColor = value;
                this.RaisePropertyChanged(nameof(LeftColor));
                ApplicationDomainEx.ClientConfigInfo.LeftColor = value;
            }
        }

        #endregion

        #region RightColor -- 方向向右颜色

        private Color rightColor = ApplicationDomainEx.ClientConfigInfo.RightColor;
        /// <summary>
        /// 方向向右颜色
        /// </summary>
        public Color RightColor
        {
            get { return rightColor; }
            set
            {
                rightColor = value;
                this.RaisePropertyChanged(nameof(RightColor));
                ApplicationDomainEx.ClientConfigInfo.RightColor = value;
            }
        }

        #endregion

        #region SafeColor -- 安全颜色

        private Color safeColor = ApplicationDomainEx.ClientConfigInfo.SafeColor;
        /// <summary>
        /// 安全颜色
        /// </summary>
        public Color SafeColor
        {
            get { return safeColor; }
            set
            {
                safeColor = value;
                this.RaisePropertyChanged(nameof(SafeColor));
                ApplicationDomainEx.ClientConfigInfo.SafeColor = value;
            }
        }

        #endregion
    }
}
