﻿using log4net;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;
using VIZ.ElectricRabbit.Domain;
using VIZ.ElectricRabbit.Storage;
using VIZ.Framework.Common;
using VIZ.Framework.Core;
using VIZ.Framework.Domain;
using VIZ.Framework.Module;

namespace VIZ.ElectricRabbit.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化算法
    /// </summary>
    public class AppSetup_InitAlgorithm : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitAlgorithm));

        /// <summary>
        /// 算法路径
        /// </summary>
        private readonly static string CLIENT_ALGORITHM_PATH = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, string>(p => p.CLIENT_ALGORITHM_PATH);

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化算法";

        /// <summary>
        /// 算法进程
        /// </summary>
        private Process AlgorithmProcess;

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            // 如果未配置，那么不处理
            if (string.IsNullOrWhiteSpace(CLIENT_ALGORITHM_PATH))
                return true;

            this.AlgorithmProcess = this.CreateSetupProcess(CLIENT_ALGORITHM_PATH);
            this.AlgorithmProcess?.Start();

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            this.AlgorithmProcess?.Kill();
        }

        /// <summary>
        /// 创建启动进程
        /// </summary>
        /// <param name="path">进程路径</param>
        /// <returns>进程对象</returns>
        private Process CreateSetupProcess(string path)
        {
            StringBuilder sb = new StringBuilder();

            string fileName = null;
            string arguments = null;
            if (System.IO.Path.GetExtension(path).ToLower() == ".py")
            {
                // 如果是 .py 文件那么 采用 CMD 启动python程序
                fileName = "python";
                arguments = $"\"{path}\"";
            }
            else
            {
                // 否则采用直接启动的方式启动
                fileName = path;
                arguments = $"{sb}";
            }

            Process proc = new Process();
            proc.StartInfo.UseShellExecute = true;
            proc.StartInfo.FileName = fileName;
            proc.StartInfo.Arguments = arguments;
            proc.StartInfo.WindowStyle = ProcessWindowStyle.Normal;

            return proc;
        }
    }
}