﻿using SharpDX.Direct2D1;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 视频插件
    /// </summary>
    public interface IVideoPlugin
    {
        /// <summary>
        /// 插件名称
        /// </summary>
        string Name { get; }

        /// <summary>
        /// 视频控件
        /// </summary>
        VideoControl VideoControl { get; }

        /// <summary>
        /// 视频渲染
        /// </summary>
        VideoCustomRender VideoRender { get; }

        /// <summary>
        /// 是否启用
        /// </summary>
        bool IsEnabled { get; set; }

        /// <summary>
        /// 附加
        /// </summary>
        void Attach();

        /// <summary>
        /// 卸载
        /// </summary>
        void Detach();

        /// <summary>
        /// 渲染
        /// </summary>
        /// <param name="context">渲染上下文</param>
        void Render(VideoRenderContext context);
    }
}
