﻿using SharpDX.Mathematics.Interop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 裁剪框信息
    /// </summary>
    public class ClipBoxInfo
    {
        /// <summary>
        /// 源区域
        /// </summary>
        public RawRectangleF SrcRect { get; set; }

        /// <summary>
        /// 绘制边框颜色
        /// </summary>
        public RawColor4 DrawingBorderColor { get; set; }

        /// <summary>
        /// 绘制边框宽度
        /// </summary>
        public float DrawingBorderWidth { get; set; }

        /// <summary>
        /// 遮罩颜色
        /// </summary>
        public RawColor4 MaskColor { get; set; }

        /// <summary>
        /// 中心轴颜色
        /// </summary>
        public RawColor4 CenterAxisColor { get; set; }

        /// <summary>
        /// 中心轴宽度
        /// </summary>
        public float CenterAxisWidth { get; set; }

        /// <summary>
        /// 是否启用中心轴
        /// </summary>
        public bool IsCenterAxisEnabled { get; set; }

        /// <summary>
        /// 时码
        /// </summary>
        public long TimeCode { get; set; }
    }
}
