﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 框选框插件扩展
    /// </summary>
    public static class SelectionBoxExpand
    {
        /// <summary>
        /// 更新框选框
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        /// <param name="selectionBoxInfo">框选框信息</param>
        public static void UpdateSelectionBox(this VideoControl videoControl, SelectionBoxInfo selectionBoxInfo)
        {
            if (videoControl.videoRender == null)
                return;

            SelectionBoxPlugin plugin = videoControl.GetPlugin<SelectionBoxPlugin>(VideoControlPluginNames.SelectionBox);
            if (plugin == null)
                return;

            plugin.Update(selectionBoxInfo);
        }

        /// <summary>
        /// 清理框选框
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        public static void ClearSelectionBox(this VideoControl videoControl)
        {
            if (videoControl.videoRender == null)
                return;

            SelectionBoxPlugin plugin = videoControl.GetPlugin<SelectionBoxPlugin>(VideoControlPluginNames.SelectionBox);
            if (plugin == null)
                return;

            plugin.Update(null);
        }
    }
}
