﻿using SharpDX.Direct2D1;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 视频插件基类
    /// </summary>
    public abstract class VideoPluginBase : IVideoPlugin
    {
        /// <summary>
        /// 视频插件基类
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        public VideoPluginBase(VideoControl videoControl)
        {
            this.VideoControl = videoControl;
            this.VideoRender = videoControl.videoRender;
        }

        /// <summary>
        /// 插件名称
        /// </summary>
        public abstract string Name { get; }

        /// <summary>
        /// 视频控件
        /// </summary>
        public VideoControl VideoControl { get; private set; }

        /// <summary>
        /// 视频渲染
        /// </summary>
        public VideoCustomRender VideoRender { get; private set; }

        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled { get; set; } = true;

        /// <summary>
        /// 附加
        /// </summary>
        public virtual void Attach()
        {

        }

        /// <summary>
        /// 卸载
        /// </summary>
        public virtual void Detach()
        {

        }

        /// <summary>
        /// 渲染
        /// </summary>
        /// <param name="context">渲染上下文</param>
        public abstract void Render(VideoRenderContext context);
    }
}
