﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// NDI流任务
    /// </summary>
    public abstract class NDIStreamTaskBase : VideoStreamTaskBase
    {
        /// <summary>
        /// NDI工具任务
        /// </summary>
        /// <param name="stream">NDI流</param>
        public NDIStreamTaskBase(NDIStream stream)
        {
            this.Stream = stream;
        }

        /// <summary>
        /// 任务名称
        /// </summary>
        public abstract NDIStreamTaskNames Name { get; }

        /// <summary>
        /// NDI工具
        /// </summary>
        public NDIStream Stream { get; private set; }
    }
}
