﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using NewTek;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 处理OpenCV视频帧任务
    /// </summary>
    public class OpenCVStreamExecuteVideoTask : OpenCVStreamTaskBase
    {
        /// <summary>
        /// 处理NDI视频帧任务
        /// </summary>
        /// <param name="stream">OpenCV流</param>
        public OpenCVStreamExecuteVideoTask(OpenCVStream stream) : base(stream)
        {

        }

        /// <summary>
        /// 任务名称
        /// </summary>
        public override OpenCVStreamTaskNames Name => OpenCVStreamTaskNames.EXECUTE_VIDEO;

        /// <summary>
        /// 执行
        /// </summary>
        protected override void Execute()
        {
            while (this.IsStarted)
            {
                if (this.Stream.VideoFrameQueue.Count <= this.Stream.Option.DelayFrame)
                {
                    Thread.Sleep(2);

                    continue;
                }

                if (!this.Stream.VideoFrameQueue.TryDequeue(out IVideoFrame frame))
                {
                    continue;
                }

                // 触发视频帧处理事件
                this.Stream.TriggerExecuteVideoFrame(frame);

                Thread.Sleep(10);
            }
        }
    }
}
