﻿using OpenCvSharp;
using SharpDX;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 视频帧基类
    /// </summary>
    public abstract class VideoFrameBase : IVideoFrame
    {
        /// <summary>
        /// 视频帧基类
        /// </summary>
        public VideoFrameBase()
        { }

        /// <summary>
        /// 视频帧基类
        /// </summary>
        /// <param name="color">颜色</param>
        public VideoFrameBase(Scalar color)
        {
            this.Width = 1;
            this.Height = 1;
            this.Length = 4;

            this.DataStream = new DataStream(this.Length, true, true);

            Mat mat = new Mat(1, 1, MatType.CV_8UC4, color);

            unsafe
            {
                Buffer.MemoryCopy(mat.DataPointer, this.DataStream.DataPointer.ToPointer(), this.Length, this.Length);
            }

            mat.Dispose();
        }

        /// <summary>
        /// 宽度
        /// </summary>
        public int Width { get; set; }

        /// <summary>
        /// 高度
        /// </summary>
        public int Height { get; set; }

        /// <summary>
        /// 数据长度
        /// </summary>
        public int Length { get; set; }

        /// <summary>
        /// 时间戳
        /// </summary>
        public long TimeStamp { get; set; }

        /// <summary>
        /// 是否是最后一帧
        /// </summary>
        public bool IsEnd { get; set; }

        /// <summary>
        /// 画面数据
        /// </summary>
        public DataStream DataStream { get; set; }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.DataStream?.Dispose();
            this.DataStream = null;
        }
    }
}
