﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 视频流任务基类
    /// </summary>
    public abstract class VideoStreamTaskBase : IDisposable
    {
        /// <summary>
        /// 是否开启
        /// </summary>
        public bool IsStarted { get; set; }

        /// <summary>
        /// 任务线程
        /// </summary>
        private Thread Thread;

        /// <summary>
        /// 开始
        /// </summary>
        public virtual void Start()
        {
            if (this.IsStarted)
                throw new Exception("task is already started.");

            this.IsStarted = true;

            this.Thread = new Thread(this.Execute);
            this.Thread.IsBackground = true;

            this.Thread.Start();
        }

        /// <summary>
        /// 停止
        /// </summary>
        public virtual void Stop()
        {
            this.IsStarted = false;

            this.Thread = null;
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public virtual void Dispose()
        {
            this.Stop();
        }

        /// <summary>
        /// 执行
        /// </summary>
        protected abstract void Execute();
    }
}
