﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 热键辅助类
    /// </summary>
    public static class HotkeyHelper
    {
        /// <summary>
        /// 获取热键值
        /// </summary>
        /// <param name="e">键盘事件</param>
        /// <returns>热键值</returns>
        public static string GetHotkey(KeyEventArgs e)
        {
            StringBuilder sb = new StringBuilder();

            // Ctl Alt Shift
            if (e.KeyboardDevice.IsKeyDown(Key.LeftCtrl) || e.KeyboardDevice.IsKeyDown(Key.RightCtrl))
            {
                sb.Append("Ctrl + ");
            }
            if (e.KeyboardDevice.IsKeyDown(Key.LeftAlt) || e.KeyboardDevice.IsKeyDown(Key.RightAlt))
            {
                sb.Append("Alt + ");
            }
            if (e.KeyboardDevice.IsKeyDown(Key.LeftShift) || e.KeyboardDevice.IsKeyDown(Key.RightShift))
            {
                sb.Append("Shift + ");
            }

            // D0 - D9 A - Z
            for (int i = (int)Key.D0; i <= (int)Key.Z; i++)
            {
                Key key = (Key)i;
                if (e.KeyboardDevice.IsKeyDown(key))
                {
                    sb.Append($"{key}");
                    break;
                }
            }

            // F1 - F12
            for (int i = (int)Key.F1; i <= (int)Key.F12; i++)
            {
                Key key = (Key)i;
                if (e.KeyboardDevice.IsKeyDown(key))
                {
                    sb.Append($"{key}");
                    break;
                }
            }

            return sb.ToString();
        }

        /// <summary>
        /// 获取热键值
        /// </summary>
        /// <param name="e">键盘事件</param>
        /// <returns>热键值</returns>
        public static string GetHotkey(System.Windows.Forms.KeyEventArgs e)
        {
            StringBuilder sb = new StringBuilder();

            if (e.Control)
            {
                sb.Append("Ctrl + ");
            }
            if (e.Alt)
            {
                sb.Append("Alt + ");
            }
            if (e.Shift)
            {
                sb.Append("Shift + ");
            }
            // D0 - D9
            if (e.KeyCode >= System.Windows.Forms.Keys.D0 && e.KeyCode <= System.Windows.Forms.Keys.D9)
            {
                sb.Append($"{e.KeyCode}");
                return sb.ToString();
            }
            //  A - Z
            if (e.KeyCode >= System.Windows.Forms.Keys.A && e.KeyCode <= System.Windows.Forms.Keys.Z)
            {
                sb.Append($"{e.KeyCode}");
                return sb.ToString();
            }
            // F1 - F12
            if (e.KeyCode >= System.Windows.Forms.Keys.F1 && e.KeyCode <= System.Windows.Forms.Keys.F12)
            {
                sb.Append($"{e.KeyCode}");
                return sb.ToString();
            }

            return sb.ToString();
        }
    }
}
