﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 标签和值
    /// </summary>
    public class LabelValue : Control
    {
        static LabelValue()
        {
            DefaultStyleKeyProperty.OverrideMetadata(typeof(LabelValue), new FrameworkPropertyMetadata(typeof(LabelValue)));
        }

        #region LabelWidth -- 标签宽度

        /// <summary>
        /// 标签宽度
        /// </summary>
        public double LabelWidth
        {
            get { return (double)GetValue(LabelWidthProperty); }
            set { SetValue(LabelWidthProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for LabelWidth.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty LabelWidthProperty =
            DependencyProperty.Register("LabelWidth", typeof(double), typeof(LabelValue), new PropertyMetadata(120d));

        #endregion

        #region Label -- 标签

        /// <summary>
        /// 标签
        /// </summary>
        public string Label
        {
            get { return (string)GetValue(LabelProperty); }
            set { SetValue(LabelProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Label.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty LabelProperty =
            DependencyProperty.Register("Label", typeof(string), typeof(LabelValue), new PropertyMetadata(null));

        #endregion

        #region Text -- 文本

        /// <summary>
        /// 文本
        /// </summary>
        public string Text
        {
            get { return (string)GetValue(TextProperty); }
            set { SetValue(TextProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Text.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty TextProperty =
            DependencyProperty.Register("Text", typeof(string), typeof(LabelValue), new PropertyMetadata(null));

        #endregion
    }
}
