﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 导航项控件
    /// </summary>
    public class NavigationItemControl : ListBoxItem
    {
        static NavigationItemControl()
        {
            DefaultStyleKeyProperty.OverrideMetadata(typeof(NavigationItemControl), new FrameworkPropertyMetadata(typeof(NavigationItemControl)));
        }

        public NavigationItemControl()
        {
            this.IsVisibleChanged += NavigationItemControl_IsVisibleChanged;
        }

        #region Key -- 键

        /// <summary>
        /// 键
        /// </summary>
        public string Key
        {
            get { return (string)GetValue(KeyProperty); }
            set { SetValue(KeyProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Key.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty KeyProperty =
            DependencyProperty.Register("Key", typeof(string), typeof(NavigationItemControl), new PropertyMetadata(null));

        #endregion

        #region ViewType -- 视图类型

        /// <summary>
        /// 视图类型
        /// </summary>
        public Type ViewType
        {
            get { return (Type)GetValue(ViewTypeProperty); }
            set { SetValue(ViewTypeProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for ViewType.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty ViewTypeProperty =
            DependencyProperty.Register("ViewType", typeof(Type), typeof(NavigationItemControl), new PropertyMetadata(null));

        #endregion

        /// <summary>
        /// 可见性改变时触发
        /// </summary>
        private void NavigationItemControl_IsVisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if (!this.IsVisible)
                return;

            if (this.Content != null && this.Content.GetType() == this.ViewType)
                return;

            if (this.ViewType != null)
            {
                this.Content = this.ViewType.Assembly.CreateInstance(this.ViewType.FullName);
            }
        }
    }
}
