﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Connection
{
    /// <summary>
    /// 包解析器类型
    /// </summary>
    [Flags]
    public enum ConnPackageProviderType
    {
        /// <summary>
        /// 一般用作TCP消息，需要考虑连包情况
        /// </summary>
        TCP,

        /// <summary>
        /// 一般用作UDP消息，不需要考虑连包情况
        /// </summary>
        UDP,

        /// <summary>
        /// 一般用作串口消息，不需要考虑连包情况
        /// </summary>
        SerialPort
    }

    /// <summary>
    /// 包解析器推荐使用的协议
    /// </summary>
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = true, Inherited = true)]
    public class ConnPackageProviderAttribute : Attribute
    {
        /// <summary>
        /// 包解析器推荐使用的协议
        /// </summary>
        /// <param name="type">类型</param>
        public ConnPackageProviderAttribute(ConnPackageProviderType type)
        {
            this.Type = type;
        }

        /// <summary>
        /// 类型
        /// </summary>
        public ConnPackageProviderType Type { get; set; }
    }
}
