﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// Bool --> Bool 转化器
    /// </summary>
    public class Bool2BoolConverter : IValueConverter
    {
        /// <summary>
        /// 当值为True时的返回值
        /// </summary>
        public bool? TrueResult { get; set; } = false;

        /// <summary>
        /// 当值为False时的返回值
        /// </summary>
        public bool? FalseResult { get; set; } = true;

        /// <summary>
        /// 当值为Null时的返回值
        /// </summary>
        public bool NullResult { get; set; } = true;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value is bool?)
            {
                bool? b = (bool?)value;
                if (b == null)
                    return this.NullResult;

                return b.Value ? this.TrueResult : this.FalseResult;
            }
            else if (value is bool)
            {
                bool b = (bool)value;

                return b ? this.TrueResult : this.FalseResult;
            }
            else
            {
                return this.NullResult;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
