﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows.Media;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// Bool -> SolidColorBrush 转化器
    /// </summary>
    public class Bool2SolidColorBrushConverter : IValueConverter
    {
        /// <summary>
        /// 值为None时的画刷
        /// </summary>
        public Brush NoneBrush { get; set; } = new SolidColorBrush(Colors.White);

        /// <summary>
        /// 值为False时的画刷
        /// </summary>
        public Brush FalseBrush { get; set; } = new SolidColorBrush(Colors.White);

        /// <summary>
        /// 值为True时的画刷
        /// </summary>
        public Brush TrueBrush { get; set; } = new SolidColorBrush(Colors.Red);

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value is bool?)
            {
                bool? b = (bool?)value;
                if (b == null)
                    return this.NoneBrush;

                return b.Value ? this.TrueBrush : this.FalseBrush;
            }
            else if (value is bool)
            {
                bool b = (bool)value;

                return b ? this.TrueBrush : this.FalseBrush;
            }
            else
            {
                return this.NoneBrush;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
