﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// Bool --> Visibility 转化器
    /// </summary>
    public class Bool2VisibilityConverter : IValueConverter
    {
        /// <summary>
        /// 当值为True时的Visibility值
        /// </summary>
        public Visibility TrueVisibility { get; set; } = Visibility.Visible;

        /// <summary>
        /// 当值为False时的Visibility值
        /// </summary>
        public Visibility FalseVisibility { get; set; } = Visibility.Collapsed;

        /// <summary>
        /// 当值为Null时的Visibility值
        /// </summary>
        public Visibility NullVisibility { get; set; } = Visibility.Collapsed;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value is bool?)
            {
                bool? b = (bool?)value;
                if (b == null)
                    return this.NullVisibility;

                return b.Value ? this.TrueVisibility : this.FalseVisibility;
            }
            else if (value is bool)
            {
                bool b = (bool)value;

                return b ? this.TrueVisibility : this.FalseVisibility;
            }
            else
            {
                return this.NullVisibility;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
