﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// TimeSpan 转 Double 类型
    /// </summary>
    public enum TimeSpan2DoubleConverterType
    {
        /// <summary>
        /// 小时
        /// </summary>
        Hour,
        /// <summary>
        /// 分钟
        /// </summary>
        Minute,
        /// <summary>
        /// 秒
        /// </summary>
        Second,
        /// <summary>
        /// 毫秒
        /// </summary>
        Millisecond
    }

    /// <summary>
    /// TimeSpan 转 Double 转化器
    /// </summary>
    public class TimeSpan2DoubleConverter : IValueConverter
    {
        /// <summary>
        /// 转化类型
        /// </summary>
        public TimeSpan2DoubleConverterType Type { get; set; } = TimeSpan2DoubleConverterType.Second;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (!(value is TimeSpan))
                return 0d;

            TimeSpan timeSpan = (TimeSpan)value;

            switch (this.Type)
            {
                case TimeSpan2DoubleConverterType.Hour:
                    return timeSpan.TotalHours;
                case TimeSpan2DoubleConverterType.Minute:
                    return timeSpan.TotalMinutes;
                case TimeSpan2DoubleConverterType.Second:
                    return timeSpan.TotalSeconds;
                case TimeSpan2DoubleConverterType.Millisecond:
                    return timeSpan.TotalMilliseconds;
                default:
                    return 0d;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (!(value is double))
                return TimeSpan.Zero;

            double v = (double)value;

            switch (this.Type)
            {
                case TimeSpan2DoubleConverterType.Hour:
                    return TimeSpan.FromHours(v);
                case TimeSpan2DoubleConverterType.Minute:
                    return TimeSpan.FromMinutes(v);
                case TimeSpan2DoubleConverterType.Second:
                    return TimeSpan.FromSeconds(v);
                case TimeSpan2DoubleConverterType.Millisecond:
                    return TimeSpan.FromMilliseconds(v);
                default:
                    return TimeSpan.Zero;
            }
        }
    }
}
