﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 枚举辅助类
    /// </summary>
    public static class EnumHelper
    {
        /// <summary>
        /// 获取枚举描述信息
        /// </summary>
        /// <param name="value">枚举值</param>
        /// <returns>配置值</returns>
        public static string GetDescription(this Enum value)
        {
            if (value == null)
                return string.Empty;

            FieldInfo field = value.GetType().GetField(value.ToString());
            if (field == null)
                return string.Empty;

            DescriptionAttribute attribute = field.GetCustomAttribute<DescriptionAttribute>(false);

            if (attribute == null)
                return string.Empty;

            return attribute.Description;
        }
    }
}
