﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 位数据辅助类
    /// </summary>
    public static class ByteHelper
    {
        /// <summary>
        /// 根据字符串获取byte数据组
        /// 例如: 58 A0 01 00 00 00
        /// </summary>
        /// <param name="str">输入byte字符串</param>
        /// <returns>byte数组</returns>
        public static byte[] FromString(string str)
        {
            string[] args = str.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            byte[] result = new byte[args.Length];

            for (int i = 0; i < args.Length; ++i)
            {
                result[i] = byte.Parse(args[i], System.Globalization.NumberStyles.HexNumber);
            }

            return result;
        }
    }
}
