﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// CMD 辅助类
    /// </summary>
    public static class CmdHelper
    {
        /// <summary>
        /// CMD路径
        /// </summary>
        private const string CMD_PATH = @"C:\Windows\System32\cmd.exe";

        /// <summary>
        /// 执行
        /// </summary>
        /// <param name="command">命令</param>
        /// <param name="waitMilliseconds">等待命令返回时间</param>
        /// <returns>命令返回数据</returns>
        public static string Run(string command, int waitMilliseconds = 5000)
        {
            using (Process process = new Process())
            {
                process.StartInfo.FileName = CMD_PATH;
                process.StartInfo.UseShellExecute = false;        //是否使用操作系统shell启动
                process.StartInfo.RedirectStandardInput = true;   //接受来自调用程序的输入信息
                process.StartInfo.RedirectStandardOutput = true;  //由调用程序获取输出信息
                process.StartInfo.RedirectStandardError = true;   //重定向标准错误输出
                process.StartInfo.CreateNoWindow = true;          //不显示程序窗口
                process.Start();//启动程序

                //向cmd窗口写入命令
                process.StandardInput.WriteLine(command);
                process.StandardInput.AutoFlush = true;

                //获取cmd窗口的输出信息
                string output = process.StandardOutput.ReadToEnd();
                process.WaitForExit(waitMilliseconds);//等待程序执行完退出进程
                process.Close();

                return output;
            }
        }
    }
}
