﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 数学辅助类
    /// </summary>
    public static partial class MathHelper
    {
        /// <summary>
        /// 裁切数字
        /// </summary>
        /// <typeparam name="T">数字类型</typeparam>
        /// <param name="min">最小值</param>
        /// <param name="max">最大值</param>
        /// <param name="value">当前值</param>
        /// <returns>裁切后的数值</returns>
        public static T Clip<T>(T min, T max, T value) where T : IComparable<T>
        {
            T result = value;

            if (value.CompareTo(min) == -1)
            {
                result = min;
            }

            if (value.CompareTo(max) == 1)
            {
                result = max;
            }

            return result;
        }

        /// <summary>
        /// 获数值精度（小数点后几位）
        /// </summary>
        /// <param name="value">数值</param>
        /// <returns>精度</returns>
        public static int GetDigitsPrecision(double value)
        {
            string str = value.ToString();

            string[] items = str.Split('.');
            if (items.Length != 2)
            {
                return 0;
            }

            return items[1].Length;
        }
    }
}
