﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 消息管理类接口
    /// </summary>
    public interface IMessageManager : IDisposable
    {
        /// <summary>
        /// 注册一个消息
        /// </summary>
        /// <param name="target">关联对象</param>
        /// <param name="action">行为</param>
        void Register<T>(object target, Action<T> action);

        /// <summary>
        /// 注销关联对象的消息
        /// </summary>
        /// <param name="target">关联对象</param>
        void UnRegister(object target);

        /// <summary>
        /// 注销所有消息
        /// </summary>
        void UnRegister();

        /// <summary>
        /// 发送消息
        /// </summary>
        /// <param name="token">标志</param>
        /// <param name="message">消息</param>
        void Send<T>(T message);
    }
}
