﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 消息信息
    /// </summary>
    public class MessageInfo<T> : IMessageInfo
    {
        /// <summary>
        /// 消息类型
        /// </summary>
        public Type Type { get; set; }

        /// <summary>
        /// 关联对象
        /// </summary>
        public object Target { get; set; }

        /// <summary>
        /// 行为
        /// </summary>
        public Action<T> Action { get; set; }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.Target = null;
            this.Type = null;
            this.Action = null;
        }
    }
}
