﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Management;
using System.Net;
using System.Net.NetworkInformation;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 网络辅助类
    /// </summary>
    public static class NetHelper
    {
        /// <summary>
        /// 获取所有的Mac地址
        /// </summary>
        /// <returns>Mac地址</returns>
        public static List<NetHelperMacInfo> GetAllMacAddress()
        {
            List<NetHelperMacInfo> list = new List<NetHelperMacInfo>();

            string output = CmdHelper.Run("chcp 437 & ipconfig /all & exit");

            NetHelperMacInfo info = null;

            foreach (var line in output.Split(Environment.NewLine.ToCharArray(), StringSplitOptions.RemoveEmptyEntries))
            {
                if (string.IsNullOrWhiteSpace(line))
                    continue;

                if (!line.StartsWith(" "))
                {
                    info = new NetHelperMacInfo();
                    info.Name = line.Trim();
                    if (info.Name.EndsWith(":"))
                    {
                        info.Name = info.Name.Remove(info.Name.Length - 1, 1);
                    }
                    list.Add(info);

                    continue;
                }

                string cmd = line.Trim();

                if (cmd.StartsWith("Description"))
                {
                    info.Description = cmd.Substring(cmd.IndexOf(':') + 1).Trim();
                    continue;
                }

                if (cmd.StartsWith("Physical Address"))
                {
                    info.PhysicalAddress = cmd.Substring(cmd.IndexOf(':') + 1).Trim();
                    continue;
                }

                if (cmd.StartsWith("DHCPv6 Client DUID"))
                {
                    info.DHCPv6ClientDUID = cmd.Substring(cmd.IndexOf(':') + 1).Trim();
                    continue;
                }
            }

            list = list.Where(p => p.IsAvailable()).ToList();

            return list;
        }

        /// <summary>
        /// 获取所有的Mac地址, 采用默认的过滤器
        /// </summary>
        /// <remarks>
        /// 网络描述中包含：debug、virtual、miniport 关键字的将会被过滤
        /// </remarks>
        /// <returns>Mac地址</returns>
        public static List<NetHelperMacInfo> GetAllMacAddressWithDefaultFilter()
        {
            List<string> filter = new List<string> { "debug", "virtual", "miniport" };

            List<NetHelperMacInfo> list = GetAllMacAddress();

            list = list.Where(p => !filter.Contains(p.Description.ToLower())).ToList();

            return list;
        }

        /// <summary>
        /// 获取一个可用的UDP端口
        /// </summary>
        /// <param name="startPort">开始端口</param>
        /// <param name="endPort">结束端口</param>
        /// <param name="notIn">端口不应该再该列表中</param>
        /// <returns>可用的UDP端口</returns>
        public static int GetAvailableUdpPort(int startPort, int endPort, List<int> notIn)
        {
            //提供本地计算机有关网络连接信息
            IPGlobalProperties iPGlobalProperties = IPGlobalProperties.GetIPGlobalProperties();
            //获取可用的UDP监听终结点信息
            IPEndPoint[] iPEndPoints = iPGlobalProperties.GetActiveUdpListeners();

            for (int port = startPort; port <= endPort; port++)
            {
                if (notIn != null && notIn.Contains(port))
                    continue;

                if (iPEndPoints.Any(p => p.Port == port))
                    continue;

                return port;
            }

            return 0;
        }
    }
}
