﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 应用程序MAC地址检测
    /// </summary>
    [AttributeUsage(AttributeTargets.Assembly, Inherited = false, AllowMultiple = true)]
    public class ApplicationMacCheckAttribute : Attribute
    {
        /// <summary>
        /// 应用程序MAC地址检测
        /// </summary>
        /// <param name="macAddress">MAC地址</param>
        public ApplicationMacCheckAttribute(string macAddress)
        {
            this.MacAddress = macAddress;
        }

        /// <summary>
        /// 过期时间
        /// </summary>
        public string MacAddress { get; set; }
    }
}
