﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 应用程序时间检测
    /// </summary>
    [AttributeUsage(AttributeTargets.Assembly, Inherited = false, AllowMultiple = false)]
    public class ApplicationTimeCheckAttribute : Attribute
    {
        /// <summary>
        /// 应用程序时间检测
        /// </summary>
        /// <param name="expirationTime">过期时间</param>
        public ApplicationTimeCheckAttribute(string expirationTime)
        {
            this.ExpirationTime = DateTime.Parse(expirationTime);
        }

        /// <summary>
        /// 过期时间
        /// </summary>
        public DateTime ExpirationTime { get; set; }
    }
}
