﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 服务管理
    /// </summary>
    public interface IServiceManager
    {
        /// <summary>
        /// 添加图模型服务
        /// </summary>
        /// <param name="key">键</param>
        /// <param name="service">图模型服务</param>
        void AddService<T>(string key, T service) where T : class, IService;

        /// <summary>
        /// 移除视图模型服务
        /// </summary>
        /// <typeparam name="T">图模型服务类型</typeparam>
        /// <param name="key">服务键</param>
        void RemoveService<T>(string key) where T : class, IService;

        /// <summary>
        /// 获取图模型服务
        /// </summary>
        /// <typeparam name="T">图模型服务类型</typeparam>
        /// <param name="key">服务键</param>
        /// <returns>图模型服务</returns>
        T GetService<T>(string key) where T : class, IService;

        /// <summary>
        /// 获取视图模型服务
        /// </summary>
        /// <typeparam name="T">图模型服务类型</typeparam>
        /// <returns>图模型服务列表</returns>
        List<T> GetServiceList<T>() where T : class, IService;
    }
}
