﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// USB设备信息结构
    /// </summary>
    public struct USBDeviceStruct
    {
        /// <summary>
        /// 固件名称字符串
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public Byte[] FirmwareName;

        /// <summary>
        /// 固件编译时间字符串
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public Byte[] BuildDate;

        /// <summary>
        /// 硬件版本号
        /// </summary>
        public UInt32 HardwareVersion;

        /// <summary>
        /// 固件版本号
        /// </summary>
        public UInt32 FirmwareVersion;

        /// <summary>
        /// 适配器序列号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
        public UInt32[] SerialNumber;

        /// <summary>
        /// 适配器当前具备的功能
        /// </summary>
        public UInt32 Functions;
    }
}
