﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Markup;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// GPIO管理器
    /// </summary>
    public static class GPIOManager
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(GPIOManager));

        /// <summary>
        /// 搜索设备
        /// </summary>
        /// <returns>设备个数</returns>
        public static List<USBDeviceInfo> ScanDevice()
        {
            List<USBDeviceInfo> infos = new List<USBDeviceInfo>();

            //扫描查找设备
            int[] devHandles = new int[20];
            int devNum = USBDevice.USB_ScanDevice(devHandles);

            if (devNum <= 0)
            {
                return infos;
            }

            for (int i = 0; i < devNum; ++i)
            {
                USBDeviceInfo info = new USBDeviceInfo();
                info.Handle = devHandles[i];

                infos.Add(info);
            }

            return infos;
        }

        /// <summary>
        /// 模型集合
        /// </summary>
        public static List<GPIOModel> Models { get; private set; } = new List<GPIOModel>();
    }
}
