﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 监控管理器
    /// </summary>
    public interface IMonitorManager
    {
        /// <summary>
        /// 添加监视任务
        /// </summary>
        /// <param name="task">监视任务</param>
        void AppendTask(MonitorTaskBase task);

        /// <summary>
        /// 添加触发器
        /// </summary>
        /// <param name="name">任务名称</param>
        /// <param name="trigger">触发器</param>
        void AppendTrigger(string name, IMonitorTrigger trigger);

        /// <summary>
        /// 获取监视信息
        /// </summary>
        /// <param name="name">监视名称</param>
        /// <returns>监视模型</returns>
        T GetInfo<T>(string name) where T : MonitorInfolBase;

        /// <summary>
        /// 开始监控
        /// </summary>
        void Start();

        /// <summary>
        /// 停止监控
        /// </summary>
        void Stop();
    }
}
