﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 系统监视信息
    /// </summary>
    public class SystemMonitorInfo : MonitorInfolBase
    {
        /// <summary>
        /// CPU 利用率
        /// </summary>
        public double CpuUsedPercentage { get; set; }

        /// <summary>
        /// 内存利用率
        /// </summary>
        public double MemoryUsedPercentage { get; set; }

        /// <summary>
        /// 内存使用量
        /// </summary>
        public ulong MemoryUsed { get; set; }

        /// <summary>
        /// 内存总量
        /// </summary>
        public ulong MemoryTotal { get; set; }

        /// <summary>
        /// GPU信息集合
        /// </summary>
        public List<SystemMonitorGpuInfo> GpuInfos { get; set; } = new List<SystemMonitorGpuInfo>();
    }
}
