﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 系统监视解释器 -- 内存
    /// </summary>
    public class SystemMonitorProvider_Memory : IMonitorProvider
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string Name => "Memory";

        /// <summary>
        /// 执行
        /// </summary>
        /// <param name="info">监控信息</param>
        public void Execute(MonitorInfolBase info)
        {
            SystemMonitorInfo system = info as SystemMonitorInfo;

            Microsoft.VisualBasic.Devices.ComputerInfo computer = new Microsoft.VisualBasic.Devices.ComputerInfo();
            system.MemoryTotal = computer.TotalPhysicalMemory;
            system.MemoryUsed = system.MemoryTotal - computer.AvailablePhysicalMemory;
            system.MemoryUsedPercentage = (double)system.MemoryUsed / system.MemoryTotal;
        }
    }
}
