﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using log4net;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 系统监控
    /// </summary>
    public class SystemMonitorTask : MonitorTaskBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private ILog log = LogManager.GetLogger(typeof(SystemMonitorTask));

        public SystemMonitorTask()
        {
            // CPU
            this.providers.Add(new SystemMonitorProvider_CPU());
            // 内存
            this.providers.Add(new SystemMonitorProvider_Memory());
            // GPU
            this.providers.Add(new SystemMonitorProvider_GPU());
        }

        /// <summary>
        /// 监视名称
        /// </summary>
        public override string Name => "System";

        /// <summary>
        /// 监视间隔（单位：毫秒）
        /// </summary>
        public override int Interval => 1000;

        /// <summary>
        /// 监视模型
        /// </summary>
        public override MonitorInfolBase Info => info;

        /// <summary>
        /// 模型
        /// </summary>
        private SystemMonitorInfo info = new SystemMonitorInfo();

        /// <summary>
        /// 监视器解释器集合
        /// </summary>
        private List<IMonitorProvider> providers = new List<IMonitorProvider>();

        /// <summary>
        /// 执行监视
        /// </summary>
        protected override void Execute()
        {
            foreach (IMonitorProvider provider in this.providers)
            {
                try
                {
                    provider.Execute(this.info);
                }
                catch (Exception ex)
                {
                    log.Error(ex);
                }
            }
        }
    }
}
